// import {getCookie} from 'cookies-next/client';
import axios from "axios";
import download from "downloadjs";

export const SOCKETURL = "https://hub-node.it-rays.org:6004/";

export const taskStatuses = [
    'Not Started',
    'In Progress',
    'Completed',
    'Over Due',
]

export const taskPriorites = [
    'Low',
    'Medium',
    'High',
    'Critical',
    'Urgent',
]

export function getStatus(key: number) {
    return taskStatuses[key];
}

export function getPriority(key: number) {
    return taskPriorites[key];
}

export function formatDate(date: string, showFull = false) {
    const d:Date = new Date(date);
    const now:Date = new Date();
    const today:Date = new Date(now);
    today.setHours(0, 0, 0, 0);
    const yesterday:Date = new Date(today);
    const monthNames = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ];
    const dayNames = [
        "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
    ];
    yesterday.setDate(today.getDate() - 1);
    d.setHours(0, 0, 0, 0);
    const currentYear = new Date().getFullYear();
    if (d.getTime() === today.getTime()) {
        return formatTime(date);
    } else if (d.getTime() === yesterday.getTime()) {
        return "Yesterday";
    } else {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-expect-error
        const timeDiff = now - d;
        const oneWeekInMs = 7 * 24 * 60 * 60 * 1000;
        if (timeDiff < oneWeekInMs && timeDiff > 0) {
            return d.toLocaleDateString('en-US', { weekday: 'long' });
        } else {
            let month = (d.getMonth() + 1),
                monthName = monthNames[month - 1],
                day = d.getDate(),
                dayName = d.getDay(),
                year = d.getFullYear();
            if( year === currentYear ){
                if( showFull ){
                    return dayNames[dayName] + ', ' + [day, monthName].join(" ");
                } else {
                    return [day, month].join("/");
                }
            } else {
                return [day, month, year].join("/");
            }
        }
    }
}

export function formatTime(date: string) {
    const d:Date = new Date(date);
    return d.toLocaleString([], {
        hour: "2-digit",
        minute: "2-digit",
    });
}

export function dayAndMonthFormat(date: string) {
    let d = new Date(date),
        month = "" + (d.getMonth() + 1),
        day = "" + d.getDate();

    if (month.length < 2) month = "0" + month;
    if (day.length < 2) day = "0" + day;

    return [day, month].join("-");
}

export function getToken() {
    const token = localStorage.getItem('hub-token');
    return token;
}

export function getUserData() {
    const userData = localStorage.getItem('hub-user-session');
    return userData && userData != 'undefined' ? JSON.parse(userData) : {};
}

export function getUserRoles() {
    const user = getUserData();
    return Object.keys(user).length ? user['roles'] : [];
}

export function hasRole(roleName: string) {
    const roles = roleName.split('|');
    let hasRle = false;
    for (let i = 0; i < roles.length; i++) {
        const role = getUserRoles().find((role: { name: string }) => role.name === roles[i]);
        if (role) {
            hasRle = true;
            break;
        }
    }

    return hasRle;
}

export function downloadFile(fileName:string) {
    let obj = {  file_name: fileName };
    axios.get(import.meta.env.VITE_BASE_URL + 'chat-download-attach/' + fileName, {
            headers:
                {
                    Authorization: `Bearer ${getToken()}`
                },
            responseType: 'blob',
        }
    )
        .then((res) => {
            const data = res.data;
            if (data) {
                download(data, fileName);
            }
        }).catch((err) => {

    });
}

