export const FRONTAPPURL = import.meta.env.VITE_FRONTAPPURL;
export const APPURL = import.meta.env.VITE_BACKEND_URL;
export const FILEFORMATPATH = import.meta.env.VITE_BACKEND_URL_EXT + 'uploads/assets/images/formats/';
export const DriveURL = APPURL + "drive/";
export const ORDERSURL = DriveURL + "orders/";
export const CHATFILESURL = 'https://hub.it-rays.org' + '/uploads/chats_files/';
export const ImagesHubPath = 'https://hub.it-rays.org/uploads/media/';
export function timeFormat(time:string){
    return new Date(time).toDateString();
}
export function getOrderFile(orderId:any, fileName:any) {
    return ORDERSURL + "order-" + orderId + "/" + fileName;
}

export function drawMongodbTime(dateObject:any, locale = "") {
    let localeType = locale === "ar" ? "ar-SA" : "en-US",
        date =
            typeof dateObject == "string"
                ? dateObject
                : dateObject.$date.$numberLong * 1;

    return new Date(date).toLocaleTimeString(localeType, {
        hour: "2-digit",
        minute: "2-digit",
        hour12: true,
    });
}

export function drawMongodbDate(dateObject:any) {
    return new Date(dateObject.$date.$numberLong * 1).toLocaleString();
}

export function drawErrors(form:any, errorObject:any) {
    form.querySelectorAll(".form-control").forEach((element:any) => {
        if(element.disabled){
            element.disabled = false;
        }

    });
    let i = 0;
    for (const key in errorObject) {
        const element = form.querySelector(`.form-control[name='${key}']`) ? form.querySelector(`.form-control[name='${key}']`) : form.querySelector(`.form-control[name='${key}[]']`);
        if (element) {
            const validationSpan = element.closest(".form-group")
                .querySelector(".ryb-validation-txt");
            validationSpan.textContent = errorObject[key].join(', ');
            validationSpan.classList.add("ryb-show-error");
            if (i == 0) {
                element.scrollIntoView(false);
            }
            i++
        }
    }
}

export function clearFormErrors(form:any) {
    form.querySelectorAll(".form-control").forEach((element:any) => {
        element.disabled = !element.value;
    });
    form.querySelectorAll(".ryb-validation-txt").forEach((element:any) => {
        element.textContent = "";
        element.classList.remove("ryb-show-error");
    });
}

export function formatDateUK(dateString:any){
    const date = new Date(dateString); // Your Date object
    const day = String(date.getDate()).padStart(2, '0'); // Get the day and pad with leading zero if needed
    const month = String(date.getMonth() + 1).padStart(2, '0'); // Get the month (add 1) and pad with leading zero
    const year = date.getFullYear(); // Get the full year

    return `${month}-${day}-${year}`;

}

export function getTime(dateString:any, format = '24', showSeconds = true) {
    const date = new Date(dateString);
    const hours = date.getHours();
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');

    if (format === '12') {
        const ampm = hours >= 12 ? 'PM' : 'AM';
        const hours12 = hours % 12 || 12;
        return `${hours12}:${minutes}${showSeconds ? ":" + seconds : ''} ${ampm}`;
    } else {
        const hours24 = String(hours).padStart(2, '0');
        return `${hours24}:${minutes}${showSeconds ? ":" + seconds : ''}`;
    }
}