import React from 'react';
import {
IonList,
IonItem,
IonLabel,
IonToggle,
IonButton,
} from '@ionic/react';
import { useAuth } from '../../contexts/AuthContext';
import AppLayout from '../../components/AppLayout';

const SettingsPage: React.FC = () => {
    const { logout } = useAuth();
    const handleLogout = () => {
        logout()
    };

    return (
        <AppLayout title='Settings'>
            <IonList className="ion-padding">
                <IonItem>
                    <IonLabel>Enable Notifications</IonLabel>
                    <IonToggle slot="end" />
                </IonItem>
                <IonItem>
                    <IonLabel>Dark Mode</IonLabel>
                    <IonToggle slot="end" />
                </IonItem>
                <IonItem>
                    <IonLabel>Account</IonLabel>
                    <IonButton fill="clear" slot="end">
                        Manage
                    </IonButton>
                </IonItem>
                <IonItem>
                    <IonLabel>Privacy</IonLabel>
                    <IonButton fill="clear" slot="end">
                        View
                    </IonButton>
                </IonItem>
                <IonItem>
                    <IonLabel>Help</IonLabel>
                    <IonButton fill="clear" slot="end">
                        Contact Us
                    </IonButton>
                </IonItem>
                <IonItem>
                    <IonLabel>About</IonLabel>
                    <IonButton fill="clear" slot="end">
                        Version 1.0.0
                    </IonButton>
                </IonItem>
                <IonItem button onClick={handleLogout}>
                    <IonLabel color="danger">Log Out</IonLabel>
                </IonItem>
            </IonList>
        </AppLayout>
    );
};

export default SettingsPage;