
import {FormEvent, useEffect, useState} from "react";
import { useLocation, useHistory } from "react-router-dom";
import { useAuth } from "../contexts/AuthContext";
import PreventBack from "../components/PreventBack";
import logo from "../../public/images/logo.svg";

const Login = () => {
  
  const history = useHistory();
  const { login, isAuthenticated, isLoading, error } = useAuth();
  const [email, setEmail] = useState("");
  const [passType, setPassType] = useState("password");
  const [passEye, setPassEye] = useState("eye");
  const [password, setPassword] = useState("");
  const [errorMsg, setErrorMsg] = useState("");
  const location = useLocation();
  const from = (location.state as any)?.from?.pathname || "/dashboard";

  useEffect(() => {
    if (isAuthenticated) {
      history.replace("/dashboard");
    }
  }, [isAuthenticated, history]);

  const handleSubmit = async (e: FormEvent) => {
    e.preventDefault();
    try {
      const result = await login(email, password);
      if (result.status === 'success') {
        history.replace(from);
      } else {
        setErrorMsg(error);
      }
    } catch (err: any) {
        setErrorMsg(error);
    }
  };

  if (isAuthenticated) {
    return null;
  }

  const headLogin = () =>(
    <div className="ryb-login-head">
      <div>
        <h4>Hello</h4>
        <h2>Sign in!</h2>
      </div>
      <div className="ryb-login-logo">
        <img alt="" src={logo} />
      </div>
    </div>
  )

  let d = new Date;
  let currentYear = d.getFullYear();

  const viewPass = ()=>{
    if (passType === 'password') {
      setPassType('text');
      setPassEye('eye-off');
    } else {
      setPassType('password');
      setPassEye('eye');
    }
  }

  return (
    
    <PreventBack title={""} headerElement={headLogin()} customClass="ryb-login-page">

        <div className="login-form">

          {errorMsg ?
            <p className="ryb-login-error">{errorMsg}</p>
            :
            ''
          }

          <form onSubmit={handleSubmit}>
            <div className="form-group">
              <label htmlFor="email">Email</label>
              <input
                id="email"
                type="email"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                placeholder="you@example.com"
                required
                className="form-control"
              />
            </div>
            
            <div className="form-group">
              <label htmlFor="password">Password</label>
              <div className="ryb-pass-box">
                <input
                  id="password"
                  type={passType}
                  value={password}
                  onChange={(e) => setPassword(e.target.value)}
                  placeholder="••••••••"
                  required
                  className="form-control"
                />
                <i className={`ri-${passEye}-line ryb-eye-icon`} onClick={viewPass}></i>
              </div>
            </div>
            
            <button type="submit" className="btn" disabled={isLoading}>
              {isLoading ? ("Signing in...") : ("Proceed!")}
            </button>
          </form>

          <p className="ryb-copyrights">Copyrights &copy; {currentYear} <span className="text-primary">IT-RAYS</span> Co.</p>

        </div>

    </PreventBack>
    
  );
  
};

export default Login;
