import {Route} from "react-router-dom";
import {IonIcon, IonLabel, IonRouterOutlet, IonTabBar, IonTabButton, IonTabs} from "@ionic/react";
import {chatbubbleEllipsesOutline, mailOpenOutline, trailSignOutline, settingsOutline, copyOutline, chatbubbleEllipses} from "ionicons/icons";
import {useAuth} from "../contexts/AuthContext";
import CommunicatorPage from "./Communicator/page";
import MailPage from "./Mail/page";
import CopilotPage from "./Copilot/page";
import Chat from "./Communicator/[id]/page";
import SettingsPage from "./Settings/page";
import {Redirect, useLocation} from "react-router";
import FilesPage from "./Files/page";
import { useEffect, useState } from "react";
import MailDetails from "../pages/Mail/[id]/page";

function DashboardLayout() {
    const { isAuthenticated } = useAuth();
    const location = useLocation();
    const [ outletClass, setOutletClass ] = useState("");

    useEffect(() => {        
        if(location.pathname.includes('/chat/') || location.pathname.includes('/mail/')){
            setOutletClass(`page-chat-active`);
        } else {
            setOutletClass("");
        }
    }, [location]);

    useEffect(() => {
        if (!isAuthenticated) {
            window.location.replace("/login");
        }
    }, [isAuthenticated]);

    return (
        <div className={`ryb-main-wrap ${outletClass}`}>
            <IonTabs>

                <IonRouterOutlet>
                    <Redirect exact from="/dashboard" to="/dashboard/communicator" />
                    <Route exact path="/dashboard/communicator" component={CommunicatorPage} />
                    <Route exact path="/dashboard/mail" component={MailPage} />
                    <Route exact path="/dashboard/copilot" component={CopilotPage} />
                    <Route exact path="/dashboard/files" component={FilesPage} />
                    <Route exact path="/dashboard/settings" component={SettingsPage} />
                    <Route exact path="/dashboard/chat/:id" component={Chat} />
                    <Route exact path="/dashboard/mail/:folder/:id" component={MailDetails} />
                </IonRouterOutlet>

                <IonTabBar slot="bottom">
                    <IonTabButton tab="tab1" href="/dashboard/communicator">
                        <IonIcon aria-hidden="true" icon={chatbubbleEllipsesOutline} />
                        <IonLabel>Chats</IonLabel>
                    </IonTabButton>
                    <IonTabButton tab="tab2" href="/dashboard/mail">
                        <IonIcon aria-hidden="true" icon={mailOpenOutline} />
                        <IonLabel>Email</IonLabel>
                    </IonTabButton>
                    <IonTabButton tab="tab3" href="/dashboard/copilot">
                        <IonIcon aria-hidden="true" icon={trailSignOutline} />
                        <IonLabel>Copilot</IonLabel>
                    </IonTabButton>
                    <IonTabButton tab="tab4" href="/dashboard/files">
                        <IonIcon aria-hidden="true" icon={copyOutline} />
                        <IonLabel>Files</IonLabel>
                    </IonTabButton>
                    <IonTabButton tab="tab5" href="/dashboard/settings">
                        <IonIcon aria-hidden="true" icon={settingsOutline} />
                        <IonLabel>Settings</IonLabel>
                    </IonTabButton>
                </IonTabBar>
            </IonTabs>
        </div>
    );
}

export default DashboardLayout;