"use client";
import axios from "axios";
import { Nav, Sidenav, Tabs } from "rsuite";
import {formatDate, getToken, getUserData, SOCKETURL} from "../../utils/front";
import {useEffect, useRef, useState} from "react";
import { io } from "socket.io-client";
// import {usePathname} from "next/navigation";
import { Link, useLocation } from "react-router-dom"
import MessageType from "../../components/communication/MessageType";
import UserImage from "../../components/UserImage";
import ChatBarItem from "../../components/communication/ChatBarItem";
import useOnlinePeopleStore from "../../contexts/onlineUsers";
import useSocketIOStore from "../../contexts/socketIO";
import useChatsStore from "../../contexts/chats";
import useTeamsStore from "../../contexts/teams";
import '../../theme/chats.css';
import UserAvatar from "../../components/UserAvatar";
import AppLayout from "../../components/AppLayout";
import { IonItem } from "@ionic/react";

const CommunicatorPage = () => {
    const [chats, setChats] = useState([]);
    const [users, setUsers] = useState([]);
    const [teams, setTeams] = useState([]);
    const allChatsRef = useRef([]);
    const allUsersRef = useRef([]);
    const allTeamsRef = useRef([]);
    const user = getUserData();
    const chatsRef = useRef([]);
    const teamsRef = useRef([]);
    const setOnlinePeople = useOnlinePeopleStore((state:any) => state.setOnlinePeople);
    const socket = useSocketIOStore((state:any) => state.socket);
    const setSocket = useSocketIOStore((state:any) => state.setSocket);
    const setChatsStore = useChatsStore((state:any) => state.setChats);
    const setTeamsStore = useTeamsStore((state:any) => state.setTeams);
    let i = 0;
    let t = 0;

    useEffect(()=>{
        if(i == 0){
            i = 1;
            const userToken = getToken();
            axios.get(import.meta.env.VITE_BASE_URL + "get-chats", {
                headers: {
                    Authorization: "Bearer " + userToken,
                },
            }).then(res=>{
                const data = res.data;
                if(data.status === 'success'){
                    setChats(sortChatsByLatestMessageUpdateTime(data.chats));
                    allChatsRef.current = sortChatsByLatestMessageUpdateTime(data.chats);
                    let users:any = [];
                    data.users.map((user: any) => {
                        if (!data.chats.find((chat:any) => chat.users.find((usr:any) => usr.id == user.id && usr.id != getUserData().id ) || (chat.users.length == 1 && chat.users.find((usr:any) => usr.id == user.id )))) {
                            users.push(user);
                        }
                    });
                    setUsers(users);
                    allUsersRef.current = users;
                    setTeams(sortChatsByLatestMessageUpdateTime(data.teams));
                    allTeamsRef.current = sortChatsByLatestMessageUpdateTime(data.teams);
                }
            }).catch((res)=>{
                console.log(res);
            });
        }

    }, []);

    useEffect(() => {
        chatsRef.current = chats;
        setChatsStore(chats);
    }, [chats]);

    useEffect(() => {
        teamsRef.current = teams;
        setTeamsStore(teams);
    }, [teams]);

    const updateChats = (oldChats:any,newMessage:any, chatId:any, chatRefCurr:any, action:any = null)=>{
        let arr:any = [];
        let chat = chatRefCurr.find((chat:any)=> chat.id == chatId);
        if(chat){
            if(newMessage.senderId != user.id && action === 'new-message' && chat.latestMsg && chat.latestMsg._id != newMessage._id){
                chat.messages.unseenCount += 1;
            }
            chat.latestMsg = newMessage;
            let time = newMessage.updatedAt.$date ? newMessage.updatedAt.$date.$numberLong :  new Date(newMessage.updatedAt).getTime().toString();
            chat.latestMsg.updatedAt = {
                $date:{
                    $numberLong:time,
                }
            }
        }


        oldChats.map((cht:any)=>{
            arr.push(cht.id == chat?.id ? chat : cht);
        });

        return sortChatsByLatestMessageUpdateTime(arr);
    }

    useEffect(() => {
        if (Object.keys(user).length) {
            if(t == 0){
                t = 1;
                const socketio = io(SOCKETURL);
                socketio.on('message', (data) => {
                    socketio.emit('join-user-room', { userId: user['id'] });
                });
                setSocket(socketio);
                socketio.on('have-a-message', ({chatId, newMessage, type, chat, action, sendNotification})=>{
                    if(action === 'seen'){
                        let fn = type === 'team' ? setTeams : setChats;
                        fn((oldChats:any [])=> {
                            let arr:[] = [];
                            oldChats.map((cht:any)=>{
                                if(cht.id == chatId){
                                    let obj:any = {...cht};
                                    obj.messages = {msgs:[], unseenCount: 0};
                                    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                    // @ts-expect-error
                                    arr.push(obj);
                                }else{
                                    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                    // @ts-expect-error
                                    arr.push(cht);
                                }
                            })
                            return arr;
                        });
                    }else if(action !== 'new-call'){
                        if(type === 'team'){
                            if(teamsRef.current.find((chat:any)=> chat.id == chatId)){
                                setTeams((oldChats)=>updateChats(oldChats, newMessage, chatId, teamsRef.current, action));
                            }
                        }else{
                            if(chatsRef.current.find((chat:any)=> chat.id == chatId)){
                                setChats((oldChats)=>updateChats(oldChats, newMessage, chatId, chatsRef.current, action));
                            }else{
                                chat.latestMsg = newMessage;
                                let time = newMessage.updatedAt.$date ? newMessage.updatedAt.$date.$numberLong :  new Date(newMessage.updatedAt).getTime().toString();
                                chat.latestMsg.updatedAt = {
                                    $date:{
                                        $numberLong:time,
                                    }
                                }
                                setChats((oldChats)=>updateChats([chat, ...oldChats], newMessage, chat.id, chatsRef.current, action));
                            }
                        }
                    }

                });

                // set online people
                socketio.on('user:online', (onlineUsers) => {
                    setOnlinePeople(onlineUsers);
                });
            }
        }

        return () => {
            socket?.off("user:online", (onlineUsers:any) => {
                setOnlinePeople(onlineUsers);
            });
        };
    }, []);

    function sortChatsByLatestMessageUpdateTime(chats:any) {
        return chats.toSorted((a:any, b:any) => {
            const aTime = a.latestMsg && a.latestMsg.updatedAt && a.latestMsg.updatedAt.$date && a.latestMsg.updatedAt.$date.$numberLong;
            const bTime = b.latestMsg && b.latestMsg.updatedAt && b.latestMsg.updatedAt.$date && b.latestMsg.updatedAt.$date.$numberLong;

            if (aTime === undefined || aTime === null) {
                return 1; // Chats without a latest message go to the end
            }
            if (bTime === undefined || bTime === null) {
                return -1; // Chats without a latest message go to the end
            }

            return parseInt(bTime) - parseInt(aTime); // Sort in descending order (latest first)
        });
    }

    function searchPeople(e:any){
        const search = e.target.value;
        if(search.length > 0){
            const filteredChats = allChatsRef.current.filter((chat:any)=> {
                const otherUser = chat.users.find((usr:any)=>usr.id != chat.pivot.user_id);
                return otherUser && otherUser.fullName.toLowerCase().includes(search.toLowerCase());
            });
            const filteredTeams = allTeamsRef.current.filter((team:any)=>team.name.toLowerCase().includes(search.toLowerCase()));
            const filteredUsers = allUsersRef.current.filter((user:any)=>user.fullName.toLowerCase().includes(search.toLowerCase()));
            setChats(filteredChats);
            setTeams(filteredTeams);
            setUsers(filteredUsers);
        }else{
            setChats(allChatsRef.current);
            setTeams(allTeamsRef.current);
            setUsers(allUsersRef.current);
        }
    }

    return (
        <AppLayout title={"Chats"} headerElement={<div className="ryb-flx-last"><UserAvatar /></div>}>

            <div className="ryb-chats-wrap">
                
                <div className="ryb-srch-form">
                    <input type="text" className="form-control" placeholder="Find employees or teams..." onChange={searchPeople} />
                </div>

                <Tabs defaultActiveKey="recent" appearance="pills" className={"ryb-chat-nav"}>

                    <Tabs.Tab eventKey="recent" title="Recent Chats">
                        { chats && chats.length ?
                            chats.map((chat:any, index)=>{
                                return <ChatBarItem chat={chat} key={'chat-' + index} />
                            })
                            :
                            <div className="ryb-no-data-msg"><i className="ri-forbid-2-line"></i>No data found!</div>
                        }
                    </Tabs.Tab>

                    <Tabs.Tab eventKey="teams" title="Teams">
                        { teams.length ?
                            teams.map((team:any)=>{
                                const lastMsgSender = team.latestMsg ? team.users.find((usr:any)=>usr.id == team.latestMsg.senderId) : null;
                                const createdAt = team.latestMsg?.createdAt;
                                let msgDate;
                                if (typeof createdAt === "string") {
                                    msgDate = new Date(createdAt);
                                } else if (createdAt?.$date?.$numberLong) {
                                    const timestamp = Number(createdAt.$date.$numberLong);
                                    msgDate = new Date(timestamp);
                                } else {
                                    msgDate = new Date(NaN);
                                }
                                if (isNaN(msgDate.getTime())) {
                                    msgDate = "Invalid Date";
                                } else {
                                    msgDate = msgDate.toLocaleString('sv-SE', { year: 'numeric', month: 'numeric', day: 'numeric' });
                                }
                                return(
                                    <Link key={team.id + 'name'} to={`/dashboard/chat/${team.id}?type=team`} className="ryb-chat-item">
                                        <div>
                                            <UserImage user={team} type="team" count={team.messages.unseenCount} width={42} height={42} />
                                            <span className="ryb-chat-item-content">
                                                {msgDate && createdAt && <span className="ryb-msg-time">{formatDate(msgDate)}</span>}
                                                <span className="font-bold">{team.name}</span>
                                                {lastMsgSender ?
                                                    <span className="ryb-latest-msg">
                                                        { lastMsgSender.id == getUserData().id && (
                                                            <>
                                                            <span className="msg-status">{
                                                                (team.latestMsg.seen.length) ? <i className={`ri-check-double-line msg-seen`}></i> : <i className={`ri-check-double-line msg-unseen`}></i>}
                                                            </span>
                                                            <b className="text-primary">You:</b>
                                                            </>
                                                        )}
                                                        <MessageType msg={team.latestMsg} inSidebar={true} userId={user.id} />
                                                    </span>
                                                    :
                                                    <span className="ryb-latest-msg">
                                                        {/*<span className="color-primary">{lastMsgSender.id == getUserData().id ? 'You' : lastMsgSender.shortName}: </span>*/}
                                                        be the first one who chat
                                                    </span>
                                                }
                                            </span>
                                        </div>
                                    </Link>
                                )
                            })
                            :
                            <div className="ryb-no-data-msg"><i className="ri-forbid-2-line"></i>No data found!</div>
                        }
                    </Tabs.Tab>

                    <Tabs.Tab eventKey="others" title="Others">
                        {users.length ?
                            users.map((user: any) => (
                                <Link className="ryb-chat-item" key={user.id + 'user'} to={`/dashboard/chat/user-${user.id}`}>
                                    <div>
                                        <UserImage user={user} count={0} width={42} height={42} type={"user"} />
                                        <span className="ryb-chat-item-content">
                                            <span className="ryb-chat-item-user-name">{user.fullName}</span>
                                            <span className="ryb-latest-msg">Hi Im using RAYSHub.</span>
                                        </span>
                                    </div>
                                </Link>
                            ))
                            :
                            <div className="ryb-no-data-msg"><i className="ri-forbid-2-line"></i>No data found!</div>
                        }
                    </Tabs.Tab>

                </Tabs>
            </div>


        </AppLayout>
    );

    // Contacts List ..........
    // import { Contacts } from "@capacitor-community/contacts";
    // import { Capacitor } from '@capacitor/core';
    // const [contactList, setContactList] = useState<any[]>([]);
    // useEffect(() => {
    //     const fetchContacts = async () => {
    //       if (Capacitor.isNativePlatform()) {
    //         try {
    //           const permissionStatus = await Contacts.requestPermissions();
    //           if (permissionStatus.contacts === 'granted') {
    //             const result = await Contacts.getContacts({
    //               projection: {
    //                 name: true,
    //                 phones: true,
    //               },
    //             });
    //             setContactList(result.contacts);
    //           } else {
    //             console.log('Permission to access contacts was denied.');
    //           }
    //         } catch (error) {
    //           console.error('Error fetching contacts:', error);
    //         }
    //       } else {
    //         console.log('Contacts API not available in the browser. Using mock data.');
    //         setContactList([
    //           { id: '1', name: { formatted: 'Web Contact 1' }, phones: [{ number: '123-456-7890' }] },
    //           { id: '2', name: { formatted: 'Web Contact 2' }, phones: [{ number: '987-654-3210' }] },
    //         ]);
    //       }
    //     };
    
    //     fetchContacts();
    // }, []);
    // return(
    //     <AppLayout title="contacts">
    //        <Sidenav className={"ryb-chat-nav"}>
    //             <Sidenav.Body>
    //                 <Nav>
    //                     <Nav.Menu eventKey="recent" className="ryb-chat-items" title="Recent Chats" as={"li"}>
    //                         {contactList.length > 0 ? 
    //                             contactList.map((contact) => {
    //                                 console.log(contact);
    //                                 return (
    //                                     <Nav.Item key={contact.contactId}>
    //                                         {contact.name.display || 'Unknown Name'}
    //                                         {contact.phones && contact.phones.map((phone: { number: string }, ind: number) => {
    //                                             return(<div key={ind}>{phone.number}</div>)
    //                                         })}
    //                                     </Nav.Item>
    //                                 )
    //                             })
    //                             :
    //                             <Nav.Item>No Results</Nav.Item>
    //                         }
    //                     </Nav.Menu>
    //                 </Nav>
    //             </Sidenav.Body>
    //         </Sidenav>
    //     </AppLayout>
    // );

};
export default CommunicatorPage;


