import { useEffect, useState } from "react";
import { createPortal } from "react-dom";
import styles from './Modal.module.css';

function Modal({ children, trigger = null, refer, className = '' }) {
    const [openModal, setOpenModal] = useState(false);
    useEffect(() => {        
        if (trigger) {
            const btnEl = document.getElementById(trigger);
            if (btnEl) {
                btnEl.addEventListener('click', function (e) {
                    e.preventDefault();
                    setOpenModal(true);
                });
            }
        }
        if(refer){
            refer.current = {};
            if (refer.current) {
                refer.current.dismiss = function () {
                    setOpenModal(false);
                }
                refer.current.open = function () {
                    setOpenModal(true);
                }
            }
        }


    }, []);

    return (
        <>
            {openModal && createPortal(
                <div className={"popup-container" + (className ? ' ' + className : '')}>
                    <i className="ri-close-line" onClick={() => setOpenModal(false)}></i>
                    <div>
                        {children}
                    </div>
                </div>,
                document.body)}
        </>
    )
}

export default Modal;