

export const configration = {
    config: {
        'iceServers': [
            // {
            //     urls: [
            //         'stun:it-rays.net:3478',
            //         'turn:it-rays.net:3478?transport=udp',
            //         'turn:it-rays.net:3478?transport=tcp',
            //         'turns:it-rays.net:5349?transport=tcp'
            //     ],
            //     username: "itrays",
            //     credential: "ITRAYSP@ssw0rd",
            // }
            {
                urls: "stun:jadeerlaw.com.sa"
            },
            {
                urls: "turn:jadeerlaw.com.sa",
                username: "jadeerlaw",
                credential: "JadeerPass@010203",
            }
        ]
    }
}

export const mediaErrorMap:any =  {
    // Standard Errors
    'NotAllowedError': 'Your browser or device blocked camera/microphone access. Please check permissions.',
    'NotFoundError': 'No camera/microphone detected. Check if your device has one and it’s connected.',
    'NotReadableError': 'Camera/microphone is already in use (e.g., by another app). Close other apps and try again.',
    'OverconstrainedError': 'Your device doesn’t support the requested quality. Trying lower resolution/audio quality may help.',
    'SecurityError': 'Your browser requires a secure connection (try HTTPS or localhost).',
    'TypeError': 'Invalid settings. The app may need an update.',

    // Browser-Specific
    'AbortError': 'Device access was interrupted. Refresh the page or restart your device.',
    'PermissionDeniedError': 'You clicked "Block" when asked for camera/mic access. Reset permissions in browser settings.',
    'PermissionDismissedError': 'You closed the permission popup without answering. Reload and click "Allow".',

    // Hardware/System Issues
    'HardwareError': 'Camera/microphone hardware failed. Check if it works in another app.',
    'OSPermissionError': 'Your computer’s settings blocked access. Enable camera/mic in system preferences.',
    'DriverError': 'Driver issue. Update your camera/microphone drivers.',

    // Fallback
    'default': 'Something went wrong. Try: (1) Reloading the page, (2) Checking browser permissions, or (3) Restarting your device.'
};

function getOptimizedConstraints(hasVideo: boolean, preferredCamera: 'user' | 'environment' = 'user') {
    // Basic audio constraints that work well across devices
    const audioConstraints = {
      echoCancellation: true,
      noiseSuppression: true,
      autoGainControl: true
    };
    
    // Video constraints optimized for mobile
    const videoConstraints = hasVideo ? {
      width: { ideal: 640, max: 1280 },
      height: { ideal: 480, max: 720 },
      frameRate: { ideal: 15, max: 24 },
      facingMode: preferredCamera // 'user' for front camera, 'environment' for back camera
    } : false;
    
    return {
      audio: audioConstraints,
      video: videoConstraints
    };
  }
  

export function getPermissions(hasVideo = false) {

    if (navigator.mediaDevices === undefined) {
        navigator.mediaDevices = {};
    }
    if (navigator.mediaDevices.getUserMedia === undefined) {
        navigator.mediaDevices.getUserMedia = function (constraints) {
            const getUserMedia =
                navigator.webkitGetUserMedia || navigator.mozGetUserMedia;
            if (!getUserMedia) {
                return Promise.reject(
                    new Error("getUserMedia is not implemented in this browser")
                );
            }
            return new Promise((resolve, reject) => {
                getUserMedia.call(navigator, constraints, resolve, reject);
            });
        };
    }
    navigator.mediaDevices.getUserMedia =
        navigator.mediaDevices.getUserMedia ||
        navigator.webkitGetUserMedia ||
        navigator.mozGetUserMedia;

    let constraints = getOptimizedConstraints(hasVideo, 'user');

    return new Promise((resolve, reject) => {
        navigator.mediaDevices
            .getUserMedia(constraints)
            .then(stream => {
                resolve(stream);
            })
            .catch(err => {
                reject(err);
            });
    });

}

export function stopStream(videoElem:any) {
    if (videoElem) {
        const stream = videoElem.srcObject;
        if (stream) {
            const tracks = stream.getTracks();
            tracks.forEach((track:any) => {
                track.stop();
            });
        }
        videoElem.srcObject = null;
    }
}

export function toggleCamera(element:any) {
    element.srcObject.getVideoTracks()[0].enabled = !element.srcObject.getVideoTracks()[0].enabled;
}

export function toggleAudio(element:any) {
    element.srcObject.getAudioTracks()[0].enabled = !element.srcObject.getAudioTracks()[0].enabled;
}

export function shareScreen(element:any, call:any, localStream:any, isShareScreen:any) {
    const displayMediaOptions = {
        video: {
            cursor: "always"
        },
        audio: false
    };
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-expect-error
    navigator.mediaDevices.getDisplayMedia(displayMediaOptions).then((stream) => {
        element.srcObject = stream;
        element.srcObject.getVideoTracks()[0].addEventListener('ended', () => {
            stopShareScreen(element, call, localStream, isShareScreen);
        })
        isShareScreen.current = true;
        element.play();
        call.peerConnection.getSenders().forEach((sender:any) => {
            if (sender.track.kind === 'video') {
                sender.replaceTrack(stream.getVideoTracks()[0]);
            }
        });
    });
}

export function stopShareScreen(element:any, call:any, localStream:any, isShareScreen:any) {
    if (element) {
        const icn:any = document.querySelector('.ryb-share-screen-btn i');
        icn.classList.remove('ri-stop-circle-line');
        icn.classList.add('ri-share-forward-box-line');
        element.srcObject.getTracks().forEach((track:any) => track.stop());
        element.srcObject = localStream.current;
        element.play();
        isShareScreen.current = false;
        call.peerConnection.getSenders().forEach((sender:any) => {
            if (sender.track.kind === 'video') {
                sender.replaceTrack(localStream.current.getVideoTracks()[0]);
            }
        });
    }
}

export function searchMessage(value:any, messages:[], scrollToElement:any) {
    // let value = searchInput.current?.value;
    if (value) {
        let filteredMessages:any = messages.filter((message:any) =>
            message.message.toLowerCase().includes(value.toLowerCase()) && message.deleted != 1
        );
        if (filteredMessages.length) {
            document.querySelectorAll('.ryb-focus-bubble').forEach((el) => {
                el.classList.remove('ryb-focus-bubble');
            });
            let element:any = document.getElementById(filteredMessages[filteredMessages.length - 1]._id);
            element.classList.add("ryb-focus-bubble");
            scrollToElement(element);
        } else {
            document.querySelectorAll('.ryb-focus-bubble').forEach((el) => {
                el.classList.remove('ryb-focus-bubble');
            });
        }
    } else {
        document.querySelectorAll('.ryb-focus-bubble').forEach((el) => {
            el.classList.remove('ryb-focus-bubble');
        });
    }
}

// export function isUserOnline(userId){
//     return
// }