import {CHATFILESURL} from "../../../utils/common";
import styles from "../../../components/communication/Bubble.module.css";
import Modal from "../../../components/Modal";
import {downloadFile} from "../../../utils/front";
import React, {useRef, useState} from "react";

function ImagesModal({msg, msgsArr}:{msg:any, msgsArr:any}){
    const modalRef = useRef<any>(null);
    const [activeImg, setActiveImg] = useState(0);
    const handleNext = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === msgsArr.length - 1 ? 0 : prevIndex + 1
        );
    };

    const handlePrev = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === 0 ? msgsArr.length - 1 : prevIndex - 1
        );
    };

    const handleThumbnailClick = (index:number) => {
        setActiveImg(index);
    };

    const handleImgClick = (index:number) => {
        setActiveImg(index);
    };

    return (
        <>
            <img alt="image" src={CHATFILESURL + msg.message} className={styles.msgImageEl} width={200} height={200} onClick={() => {handleImgClick(msgsArr.findIndex((ms:any) => ms._id == msg._id)); modalRef.current?.open()}} />
            <Modal trigger={null} ref={modalRef}>
                {/* <button onClick={handlePrev} className="ryb-img-nav-arrow ryb-img-nav-prev" disabled={msgsArr.length <= 1}><i className="ri-arrow-left-s-line"></i></button> */}
                {/* <button onClick={handleNext} className="ryb-img-nav-arrow ryb-img-nav-next" disabled={msgsArr.length <= 1}><i className="ri-arrow-right-s-line"></i></button> */}
                <button className="ryb-download-img" onClick={()=> downloadFile(msgsArr[activeImg].message)}>Download <i className="ri-download-line"></i></button>
                <div className="ryb-modal-gallery-imgs">
                    { msgsArr.map((ms:any, index:number) => (
                        <div key={index} data-index={index} className={activeImg == index ? 'active' : ''}>
                            <img alt="" src={CHATFILESURL + ms.message} className={styles.msgImageEl} />
                        </div>
                    ))}
                </div>
                <div className="ryb-modal-gallery-thumbs">
                    { msgsArr.map((ms:any, index:number) => (
                        <div key={index + '-thumb'} onClick={() => handleThumbnailClick(index)}
                             className={activeImg == index ? 'active' : ''}>
                            <img alt="" src={CHATFILESURL + ms.message} className={styles.msgImageEl} width={40} height={40} />
                        </div>
                    ))}
                </div>
            </Modal>
        </>
    )
}

export default ImagesModal;