import React, { useRef, useState } from 'react';
import { toggleCamera, toggleAudio } from './utils/methods';
import styles from './CallScreen.module.css';
import { IonToolbar, IonButtons, IonButton, IonIcon } from '@ionic/react';
import { cameraReverseOutline, micOutline, micOffOutline, volumeHighOutline, volumeMuteOutline, callSharp, videocam, videocamOff } from 'ionicons/icons';

const VideoCallControls = ( {callInstance, currentUserVideoRef, endCall, localStream} ) => {
  const [isMuted, setIsMuted] = useState(false);
  const [isCameraOff, setIsCameraOff] = useState(false);
  const [isSpeakerOn, setIsSpeakerOn] = useState(true);

  const handleMuteToggle = () => {
    toggleAudio(currentUserVideoRef.current);
    setIsMuted(!isMuted);
  };

  const handleSpeakerToggle = () => {
    setIsSpeakerOn(!isSpeakerOn);
  };

  const handleSwitchCamera = () => {
    toggleCamera(currentUserVideoRef.current);
    setIsCameraOff(!isCameraOff);
  };

  return (
    <IonToolbar>
      <IonButtons slot="primary">
        <IonButton onClick={handleSwitchCamera}>
          <IonIcon icon={isCameraOff ? videocamOff : videocam} />
        </IonButton>
        <IonButton onClick={()=>endCall(true)} className={styles.endCall}>
          <IonIcon icon={callSharp}></IonIcon>
        </IonButton>
        <IonButton onClick={handleMuteToggle}>
          <IonIcon icon={isMuted ? micOffOutline : micOutline} />
        </IonButton>
        {/* <IonButton onClick={handleSpeakerToggle}>
          <IonIcon icon={isSpeakerOn ? volumeHighOutline : volumeMuteOutline} />
        </IonButton> */}
        
      </IonButtons>
    </IonToolbar>
  );
};

export default VideoCallControls;