
'use client'
import styles from "./Bubble.module.css";
import React, {useRef, useState, useEffect} from "react";
import {CHATFILESURL, FILEFORMATPATH} from "../../utils/common";
import {downloadFile, getToken, getUserData} from "../../utils/front";
import Modal from "../Modal";
import AudioMsgPlayer from "./AudioMsgPlayer";

function MessageType({ messages = [], msg, userId, inSidebar = false }:{messages?:[], msg:any, userId:any, inSidebar?: boolean}) {
  const modalRef = useRef<any>(null);
  const [activeImg, setActiveImg] = useState(0);

  const handleThumbnailClick = (index:number) => {
    setActiveImg(index);
  };

  const handleImgClick = (index:number) => {
    setActiveImg(index);
  };

  function urlify(text:string) {
    let urlRegex = /(https?:\/\/[^\s]+)/g;
    return text.replace(urlRegex, function (url:any) {
      let domain = url.replace(/^(https?:\/\/)?(www\.)?/, '').split('/')[0];
      if( !inSidebar ){
        return '<a class="ryb-msg-link-chat" target="_blank" href="' + url + '">'
            + '<span class="ryb-lnk-inner"><i class="ri-link"></i><span class="ryb-lnk-content"><span class="ryb-lnk-text">' + url + '</span><span class="ryb-lnk-domain">' + domain + '</span></span></span>'
            + '<span class="ryb-lnk-desc">'+url+'</span>' +
            '</a>';
      } else {
        return url;
      }

    })
  }

  if (msg.deleted === 1) {
    return (
        <div className={`${styles.deletedMsg} deleted-msg`}>
          <i className="ri-delete-bin-6-fill"></i>
          {msg.senderId == userId ? 'You deleted this message!' : 'This message was deleted!'}
        </div>
    );
  } else {
    if (msg.messageType === 'image') {

      const msgsArr:any = messages?.filter((ms:any) => ms.messageType == 'image' && ms.deleted != 1)
      const handleNext = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === msgsArr.length - 1 ? 0 : prevIndex + 1
        );
      };

      const handlePrev = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === 0 ? msgsArr.length - 1 : prevIndex - 1
        );
      };

      return (
          <>
            {inSidebar ?
                <pre><i className="ri-image-line"></i>Image</pre>
                :
                <>
                  <img alt="image" src={CHATFILESURL + msg.message} className={styles.msgImageEl} width={200} height={200} onClick={() => {handleImgClick(msgsArr.findIndex((ms:any) => ms._id == msg._id)); modalRef.current?.open()}} />
                  <Modal trigger={null} ref={modalRef}>
                    <button onClick={handlePrev} className="ryb-img-nav-arrow ryb-img-nav-prev" disabled={msgsArr.length <= 1}><i className="ri-arrow-left-s-line"></i></button>
                    <button onClick={handleNext} className="ryb-img-nav-arrow ryb-img-nav-next" disabled={msgsArr.length <= 1}><i className="ri-arrow-right-s-line"></i></button>
                    <button className="ryb-download-img" onClick={()=> downloadFile(msgsArr[activeImg].message)}><i className="ri-download-line"></i></button>
                    <div className="ryb-modal-gallery-imgs">
                      { msgsArr.map((ms:any, index:number) => (
                          <div key={index} data-index={index} className={activeImg == index ? 'active' : ''}>
                            <img alt="" src={CHATFILESURL + ms.message} className={styles.msgImageEl} />
                          </div>
                      ))}
                    </div>
                    <div className="ryb-modal-gallery-thumbs">
                      { msgsArr.map((ms:any, index:number) => (
                          <div key={index + '-thumb'} onClick={() => handleThumbnailClick(index)}
                               className={activeImg == index ? 'active' : ''}>
                            <img alt="" src={CHATFILESURL + ms.message} className={styles.msgImageEl} width={40} height={40} />
                          </div>
                      ))}
                    </div>
                  </Modal>
                </>
            }
          </>
      );
    } else if (msg.messageType === 'document') {
      const ext = msg.message.split('.').pop();
      return (
          <span className={"ryb-msg-doc"}>
            { !inSidebar &&
              <span className="ryb-msg-doc-thumb" onClick={() => !inSidebar && downloadFile(msg.message)}>
                <img alt="document" width={200} height={100} src="/sample.jpg" />
              </span>
            }
            <span>
              { !inSidebar && <img alt="document" src={`${FILEFORMATPATH}${ext}.svg`} className={styles.msgImageEl} width={16} height={16} /> }
              {msg.message}
            </span>
          </span>
      );
    } else if (msg.messageType === 'audio') {
      return (
          <>{inSidebar ? <pre><i className="ri-mic-line"></i>Voice message</pre> : <AudioMsgPlayer audioUrl={CHATFILESURL + msg.message} />}</>
      )
    } else if (msg.messageType === 'missedCall' || msg.messageType === 'call') {
      let isSender = msg.senderId == getUserData().id,
          typ = msg.message == 'video' ? <i className={`ri-video-on-line ${msg.messageType === 'missedCall' ? 'missed-video' : 'done-video'}`}></i> : <svg className={msg.messageType === 'missedCall' ? styles.missedACall : styles.doneCall} xmlns="http://www.w3.org/2000/svg" width="33.807" height="28.33" viewBox="0 0 33.807 28.33"><path d="M34.526,30.644a2.272,2.272,0,0,1-2.416.832L27.479,30.3a3.171,3.171,0,0,1-2.323-3.694l.6-3.043a17.983,17.983,0,0,0-13.627.017l.607,3.021a3.18,3.18,0,0,1-2.324,3.719l-4.6,1.183a2.328,2.328,0,0,1-2.514-.964l-.015-.022A7.551,7.551,0,0,1,5.924,19.7a27.047,27.047,0,0,1,26.41.2,7.751,7.751,0,0,1,2.193,10.739ZM28.249,3.622a1.266,1.266,0,0,0-1.792,0L20.4,9.682a2.116,2.116,0,0,1-2.989,0l-3.9-3.9h2.01a1.268,1.268,0,1,0,0-2.536H10.449a1.254,1.254,0,0,0-.483.1,1.271,1.271,0,0,0-.784,1.17V9.589a1.268,1.268,0,1,0,2.536,0V7.579l3.9,3.888a4.652,4.652,0,0,0,6.572,0l6.062-6.053a1.266,1.266,0,0,0,0-1.792Z" transform="translate(-2.005 -3.25)"/></svg>,
          pretxt = msg.messageType === 'missedCall' ? ( isSender ? "Missed your " : "Missed a ") : ( isSender ? "Outgoing " : "Incoming "),
          text = msg.message == 'video' ? pretxt + 'video call.' : pretxt + 'voice call.';
      return (
          <>
            {
              inSidebar ?
                  <pre>{typ}{text}</pre>
                  :
                  <pre dangerouslySetInnerHTML={{ __html: urlify(msg.message) }} />
            }
          </>)
    } else {
      return (<pre dangerouslySetInnerHTML={{ __html: urlify(msg.message) }} />);
    }
  }

}

export default MessageType;