import {mediaErrorMap} from "./utils/methods";

function MediaStatus({status}: {status:any}){
    switch (status) {
        case 'denied':
            return (
                <div className="ryb-pop-require">
                    <div className="ryb-pop-require-img">
                        <img width={139} height={87} src="/chat/no-media.svg" alt="" />
                    </div>
                    <h6><span className="ryb-error-color">Sorry, </span> Media not enabled!</h6>
                    {'sorry you cant start call because you blocked media, please try to allow media to start call'}
                </div>
            );
        case 'video-prompt':
            return (
                <div className="ryb-pop-require">
                    <div className="ryb-pop-require-img">
                        <img width={186} height={85} src="/chat/enable-camera.svg" alt="" />
                    </div>
                    <h6>Allow Media for video call</h6>
                    You Should press allow to make call
                </div>
            );
        case 'audio-prompt':
            return (
                <div className="ryb-pop-require">
                    <div className="ryb-pop-require-img">
                        <img width={88} height={100} src="/chat/enable-mic.svg" alt="" />
                    </div>
                    <h6>Allow Microphone for audio call</h6>
                    You Should press allow to make call
                </div>
            )
        case 'prompt':
            return (
                <div className="ryb-pop-require">
                    <div className="ryb-pop-require-img">
                        <img width={88} height={100} src="/chat/enable-mic.svg" alt="" />
                    </div>
                    <h6>Allow Microphone</h6>
                    You Should press allow to make call
                </div>
            )
        case 'NotReadableError':
            return (
                <div className="ryb-pop-require">
                    {mediaErrorMap['NotReadableError']}
                </div>
            )
        case 'NotFoundError':
            return (
                <div className="ryb-pop-require">
                    {mediaErrorMap['NotFoundError']}
                </div>
            )
        case 'NotAllowedError':
            return (
                <div className="ryb-pop-require">
                    {mediaErrorMap['NotAllowedError']}
                </div>
            )
        default:
            return (
                <div className="ryb-pop-require">
                    {mediaErrorMap[status] ? mediaErrorMap[status] : mediaErrorMap['default']}
                </div>
            )
    }
}

export default MediaStatus;