import React from "react";
import styles from './LiveChat.module.css';
function DeleteMsgPop({ msg, setDeleteMsgPop, socket, chat, type, updateMessageSeenState }: { msg:any, setDeleteMsgPop:any, socket:any, chat:any, type:any, updateMessageSeenState:any }) {
    function deleteMessage() {
        socket?.emit('delete-message', { msgId: msg._id, chatId: chat.id, users: chat.users, type, chat }, ({ msgs, chatId } : { msgs:any, chatId:any }) => {
            updateMessageSeenState(msgs);
            setDeleteMsgPop(null);
        });

    }

    return (
        <div className={styles.deleteChatPopup}>
            <b className="ryb-error-color">are you sure you want to delete this message</b>
            <p>this action cant be undone</p>
            <div className={styles.deleteChatPopupBtns}>
                <button type="button" onClick={deleteMessage} className={styles.deleteChatItem}><i className="ri-delete-bin-6-line"></i>continue</button>
                <button type="button" onClick={() => setDeleteMsgPop(null)}><i className="ri-arrow-go-back-line"></i>close and back</button>
            </div>
        </div>
    );
}

export default DeleteMsgPop;