import React from "react";
import styles from './LiveChat.module.css';
function DeleteMsgPop({ msg, setDeleteMsgPop, socket, chatId, setMessages, orderType }) {
    function deleteMessage() {
        socket?.emit('delete-message', { msgId: msg._id, chatId, orderType }, ({ msgs, chatId }) => {
            setMessages(prevMessages => {
                const arr = [];
                prevMessages.map((message) => {
                    const newMsg = msgs.find(m => m._id == message._id);
                    if (newMsg) {
                        arr.push(newMsg);
                    } else {
                        arr.push(message);
                    }
                });
                return arr;
            });

            setDeleteMsgPop(null);
        });

    }

    return (
        <div className={styles.deleteChatPopup}>
            <b className="ryb-error-color">هل أنت متأكد من انك تريد حذف هذه الرسالة ؟</b>
            <p>هذه العملية لا يمكن التراجع عنها!</p>
            <div className={styles.deleteChatPopupBtns}>
                <button type="button" onClick={deleteMessage} className={styles.deleteChatItem}><i className="ri-delete-bin-6-line"></i>إكمال الحذف</button>
                <button type="button" onClick={() => setDeleteMsgPop(null)}><i className="ri-arrow-go-back-line"></i>إلغاء و رجوع</button>
            </div>
        </div>
    );
}

export default DeleteMsgPop;