import { useRef } from "react";
import React from "react";
import styles from './LiveChat.module.css';
import ToolTip from "../ToolTip/ToolTip";
import CallButtons from "./CallButtons";
import {searchMessage} from "./utils/methods";
import { useLocation } from 'react-router-dom';
// import CallGroupsButtons from "../../../components/communication/CallGroupsButtons";
import {getUserData} from "../../utils/front";

function ChatData({ messages, scrollToElement, socket, chat, setMessages, otherUser } : {messages:[], scrollToElement:any, socket: any, chat:any, setMessages:any, otherUser:any}) {
  const searchInput = useRef<HTMLInputElement>(null);
  const searchParams = new URLSearchParams(useLocation().search);
  const type = searchParams.get('type');

  return (
    <>
      <span className={styles.chatSearch}>
        <i className="ri-search-line"></i>
        <input type="search" ref={searchInput} placeholder="Search in chat..." onInput={()=> searchMessage(searchInput.current?.value, messages, scrollToElement)} />
      </span>
      <div className={styles.chatSettings}>
          {
            type === 'team'
              ?
              <></>
                // <CallGroupsButtons socket={socket} orderChat={chat} setMessages={setMessages} />
                :
                <>
                    {otherUser.id != getUserData().id && <CallButtons socket={socket} orderChat={chat} setMessages={setMessages}/>}
                </>
          }

            {/* {otherUser.id != getUserData().id &&
                <span className="ryb-chat-media-icons">
            <ToolTip text="Schedule a meeting" dir="bottom" align="right"><i
                className="ri-calendar-schedule-line"></i></ToolTip>
          </span>} */}
      </div>
    </>
  );
}

export default ChatData;
