import UserImage from "../UserImage";
import {formatDate, getUserData} from "../../utils/front";
import MessageType from "./MessageType";
import useSocketIOStore from "../../contexts/socketIO";
import {useEffect, useState} from "react";
import {Link} from "react-router-dom";

function ChatBarItem({chat, setActiveEl = null}:{chat:any, setActiveEl?:any}){
    const otherUsr = chat.users.find((usr:any)=> usr.id != chat.pivot.user_id);
    const currentUser = chat.users.find((usr:any)=> usr.id === chat.pivot.user_id);
    const lastMsgSender = chat.latestMsg ? chat.users.find((usr:any)=>usr.id == chat.latestMsg.senderId) : null;
    const socket = useSocketIOStore((state:any) => state.socket);
    const [isUserTyping, setIsUserTyping] = useState(false);

    useEffect(() => {
        socket?.on('user-typing', ({typing, chatId, userId, type}:{typing:any, chatId:any, userId:any, type:any})=>{
            if(!type && chatId == chat.id && otherUsr.id == userId){
                setIsUserTyping(typing);
            }else{
                setIsUserTyping(false);
            }
        });
    }, []);

    const Item = ({user, you = false}:{user:any, you?:any})=>{
        const createdAt = chat.latestMsg?.createdAt;
        let msgDate, msgBottom;
        if (typeof createdAt === "string") {
            msgDate = new Date(createdAt);
        } else if (createdAt?.$date?.$numberLong) {
            const timestamp = Number(createdAt.$date.$numberLong);
            msgDate = new Date(timestamp);
        } else {
            msgDate = new Date(NaN);
        }
        if (isNaN(msgDate.getTime())) {
            msgDate = "Invalid Date";
        } else {
            msgDate = msgDate.toLocaleString('sv-SE', { year: 'numeric', month: 'numeric', day: 'numeric', hour: 'numeric', minute: 'numeric' });
        }
        if( you ){
            msgBottom = <span className="ryb-latest-msg">Use this chat to make notes to yourself.</span>
        } else {
            msgBottom = <span className="ryb-latest-msg">Hi Im using RAYSHub.</span>
        }
        return(
            <Link key={chat.id} to={`/dashboard/chat/${chat.id}`} className="ryb-chat-item">
                <div>
                    <UserImage user={user} type="user" width={46} height={46} count={chat.messages.unseenCount} />
                    <span className="ryb-chat-item-content">
                        {msgDate && createdAt && <span className="ryb-msg-time">{formatDate(msgDate)}</span>}
                        <span className="ryb-chat-item-user-name">{user.fullName}{ you ? " (You)" : "" }</span>
                        { isUserTyping ?
                            <span className="ryb-latest-msg">typing...</span>
                            :
                            <>
                            {lastMsgSender ?
                                <span className="ryb-latest-msg">
                                    { lastMsgSender.id == getUserData().id && (
                                        <>
                                        <span className="msg-status">{
                                            (chat.latestMsg.seen.length) ? <i className={`ri-check-double-line msg-seen`}></i> : <i className={`ri-check-double-line msg-unseen`}></i>}
                                        </span>
                                        <b className="text-primary">You:</b>
                                        </>
                                    )}
                                    <MessageType msg={chat.latestMsg} inSidebar={true} userId={user.id} />
                                </span>
                                :
                                msgBottom
                            }
                            </>
                        }
                    </span>
                </div>
            </Link>
        )
    }

    if(otherUsr){
        return(
            <Item user={otherUsr} />
        )
    } else if(currentUser){
        return (
            <Item user={currentUser} you={true} />
        )
    }
}

export default ChatBarItem;