import React, { useState, useEffect, useRef } from "react";

function CallTimer({ showCall, minutesRef, secondsRef}) {
    const [minutes, setMinutes] = useState(typeof minutesRef === 'number' ? minutesRef : minutesRef.current);
    const [seconds, setSeconds] = useState(typeof secondsRef === 'number' ? secondsRef : secondsRef.current);
    const intervalRef = useRef(null);

    useEffect(() => {
        if (!intervalRef.current && showCall === 'answer') {
            intervalRef.current = setInterval(() => {
                setSeconds(prev => {
                    const num = prev == 59 ? 0 : prev + 1;
                    if(typeof secondsRef != 'number') secondsRef.current = num;
                    return num;
                });
            }, 1000);
        }
    }, [showCall]);

    useEffect(() => {
        if (seconds == 59) {
            setMinutes(prev => {
                const num = prev + 1;
                if(typeof minutesRef != 'number') minutesRef.current = num;
                return num;
            });
        }
    }, [seconds]);

    return (
        <>
            {minutes < 10 ? '0' + minutes : minutes}:{seconds < 10 ? '0' + seconds : seconds}
        </>
    )
}

export default CallTimer;