import { useEffect, useState } from "react";
import CallScreen from "./CallScreen";
import styles from "./LiveChat.module.css";
import {Link} from "react-router-dom";
import { useAuth } from "../../contexts/AuthContext";

function CallButtons({  socket, orderChat, setMessages }: { socket:any, orderChat:any, setMessages:any  }) {
  const { showDialog } = useAuth();
  const handleShowUserProfile = (hasVideo: boolean) => {
    showDialog(
      <CallScreen callType="ringing" orderChat={orderChat} hasVideo={hasVideo} />
    );
  };

  return (
    <>
      <span onClick={()=>{ handleShowUserProfile(true) }} className={styles.videoCall}><i className="ri-video-on-line"></i></span>
      <span onClick={()=>{ handleShowUserProfile(false) }} className={styles.voiceCall}><i className="ri-phone-line"></i></span>
    </>
  )
}

export default CallButtons;