'use client'
import styles from "./Bubble.module.css";
import React, { useState, useEffect, useRef } from "react";
import EmojiPicker from "emoji-picker-react";
import MessageType from "./MessageType";
import {getUserData} from "../../utils/front";
import {drawMongodbTime} from "../../utils/common";
import UserImage from "../../components/UserImage";
import {useParams} from "react-router-dom";
import { IonItem, IonLabel, IonModal } from "@ionic/react";
import { Modal } from "rsuite";

export default function Bubble({
   msg,
   orderChat,
   replyMsg,
   setForwardMsg,
   setReplyMsg,
   messages,
   setDeleteMsgPop,
   scrollToElement,
   socket,
   setMessages,
   type,
   setEditMsg,
   bubbleIndex
 }
 : {
  msg: any,
  orderChat: any,
  replyMsg: any,
  setForwardMsg: any,
  setReplyMsg: any,
  messages: any,
  setDeleteMsgPop: any,
  scrollToElement: any,
  socket: any,
  setMessages: any,
  type: any,
  setEditMsg: any,
  bubbleIndex: number;
}) {
  const emojiRegex = /^\p{Emoji}$/u;
  const emojiRegexDbl = /^\p{Emoji}\p{Emoji}$/u;
  const isSingleEmoji = (message:any) => {
    return emojiRegex.test(message);
  };

  const isDoubleEmoji = (message:any) => {
    return emojiRegexDbl.test(message);
  };

  const { id } = useParams<{ id: string }>();
  const user = getUserData();
  const [showEmoji, setShowEmoji] = useState(false);
  const msgSender = messageSender(msg.senderId);

  const [isLongPressing, setIsLongPressing] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const longPressTimeout = useRef<NodeJS.Timeout | null>(null);
  const longPressDuration = 500; // Adjust the duration (in milliseconds)

  const handleTouchStart = () => {
    longPressTimeout.current = setTimeout(() => {
      setIsLongPressing(true);
      setShowModal(true); // Example action: show a modal
    }, longPressDuration);
  };

  const handleTouchEnd = () => {
    if (longPressTimeout.current) {
      clearTimeout(longPressTimeout.current);
      setIsLongPressing(false);
    }
  };

  const handleMouseUp = handleTouchEnd;
  const handleMouseLeave = handleTouchEnd;

  const closeModal = () => {
    setShowModal(false);
  };

  useEffect(() => {
    return () => {
      // Clear the timeout if the component unmounts
      if (longPressTimeout.current) {
        clearTimeout(longPressTimeout.current);
      }
    };
  }, []);

  const isMyMsg = (user.id == msg.senderId );
  let userCls = isMyMsg ? styles.myChat : styles.otherChat;
  const unseenMsg = msg.seen == 0 && msg.senderId != user['id'] ? ' unseen-message' : '';
  const canIMakeActions = orderChat['users'] ?.find((usr:any) => usr.id == user.id) ? true : false;
  userCls += msg.forwarded ? ' ' + styles.forwardedMsg : '';
  userCls += isSingleEmoji(msg.message) ? ' ' + styles.singleEmoji : '';
  userCls += isDoubleEmoji(msg.message) ? ' ' + styles.doubleEmoji : '';
  let messageTypeStyle = styles.msgText;
  if (msg.messageType === 'image') {
    messageTypeStyle = styles.msgImage;
  } else if (msg.messageType === 'document') {
    messageTypeStyle = styles.msgDocument;
  }

  const checkPreviousMessage = (currentMessage) => {
    if (messages.length === 0) return false;
    const previousMessage = messages[bubbleIndex - 1];
    if( previousMessage ){
      return previousMessage.senderId == currentMessage.senderId;
    }
  };

  userCls += checkPreviousMessage(msg) ? ' ' + styles.hasPrev : '';

  function messageSender(senderId:any) {
    return orderChat['users']?.find((usr:any) => usr.id == senderId);
  }

  function emojiClick({ emoji }:{emoji:any}) {
    socket.emit('set-emoji', { emoji, msgId: msg._id, userId: user.id.toString(), chatId: orderChat.id, type }, ({ msgs, chatId }:{msgs:any, chatId:any}) => {
      setMessages((prevMessages:any) => {
        const arr:any = [];
        prevMessages.map((message:any) => {
          const newMsg = msgs.find((m:any) => m._id == message._id);
          arr.push(newMsg ? newMsg : message);
        });
        return arr;
      });
      setShowEmoji(false);
      setShowModal(false);
    });
  }
  function convertSeconds(seconds:number) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const remainingSeconds = seconds % 60;
    let timeStr = '';
    if(hours){
      timeStr += `${hours} hours, `;
    }
    if(minutes || (!minutes && hours)){
      timeStr += `${minutes} minutes, `;
    }
    return `${timeStr}${remainingSeconds} seconds`;
  }

  if (!msg.senderId || !msgSender) { return (<></>) }

  if (msg.messageType === 'missedCall' || msg.messageType === 'call') {
    const isMissedCall = msg.messageType === 'missedCall';
    const otherUser = orderChat.users.find((usr:any)=>usr.id != msgSender.id);

    return (
        <>
          {isMissedCall ?
              <li className={`${styles.missedCall} ${styles.msgItem} ${userCls}`} id={msg._id}>
                {isMissedCall &&
                    <svg className={styles.missedACall} xmlns="http://www.w3.org/2000/svg" width="33.807" height="28.33"
                         viewBox="0 0 33.807 28.33">
                      <path
                          d="M34.526,30.644a2.272,2.272,0,0,1-2.416.832L27.479,30.3a3.171,3.171,0,0,1-2.323-3.694l.6-3.043a17.983,17.983,0,0,0-13.627.017l.607,3.021a3.18,3.18,0,0,1-2.324,3.719l-4.6,1.183a2.328,2.328,0,0,1-2.514-.964l-.015-.022A7.551,7.551,0,0,1,5.924,19.7a27.047,27.047,0,0,1,26.41.2,7.751,7.751,0,0,1,2.193,10.739ZM28.249,3.622a1.266,1.266,0,0,0-1.792,0L20.4,9.682a2.116,2.116,0,0,1-2.989,0l-3.9-3.9h2.01a1.268,1.268,0,1,0,0-2.536H10.449a1.254,1.254,0,0,0-.483.1,1.271,1.271,0,0,0-.784,1.17V9.589a1.268,1.268,0,1,0,2.536,0V7.579l3.9,3.888a4.652,4.652,0,0,0,6.572,0l6.062-6.053a1.266,1.266,0,0,0,0-1.792Z"
                          transform="translate(-2.005 -3.25)"/>
                    </svg>}
                <div>
                  <span>{isMyMsg ? otherUser.first_name : 'You'} {'missed ' + (isMyMsg ? 'your ' : '')} {msg.message == 'video' ? 'video call' : 'voice call'}</span>
                  <span className={styles.msgDate}>{drawMongodbTime(msg.createdAt, 'en')}</span>
                </div>
              </li>
              :
              <li className={`${styles.call} ${styles.successCall} ${styles.msgItem} ${userCls}`} id={msg._id}>
                <span className={`${styles.msgContent} ryb-msg-content`}>
                    {msg.message == 'video' ? <i className={`ri-video-chat-fill ${styles.recievedACall}`}></i> : <i className={`ri-phone-fill ${styles.recievedACall}`}></i>}
                    <div>
                      <span>
                        {(!isMissedCall && msg.callDuration) && <b>{convertSeconds(parseInt(msg.callDuration))}</b>}
                      </span>
                      <span className={styles.msgDate}>{drawMongodbTime(msg.createdAt, 'en')}</span>
                    </div>
                </span>
              </li>
          }
        </>

    );
  } else {
    return (
      <>
        <li className={`${styles.msgItem} ${userCls}${unseenMsg} ${messageTypeStyle}${msg.deleted == 1 ? ' ' + styles.itemDeleted : ''}`} id={msg._id}>
          <IonItem 
            onTouchStart={handleTouchStart}
            onTouchEnd={handleTouchEnd}
            onMouseDown={handleTouchStart}
            onMouseUp={handleMouseUp}
            onMouseLeave={handleMouseLeave}
            >
            {
              msg.deleted == 1 ?
              <>
                <div className={styles.deletedMsg}>
                  <i className="ri-delete-bin-6-fill"></i>
                  {msg.senderId == user.id ? 'You deleted this message!' : 'This message was deleted!'}
                </div>
              </>
              :
              <>
                <div className={msg.replyOn ? styles.replyMsgWrp : ''}>
                  {msgSender.id !== user.id && <h6 className={styles.senderName}><UserImage user={msgSender} width={30} height={30} type={'user'}/>{msgSender.fullName}</h6>}
                  <span className={`${styles.msgContent} ryb-msg-content`}>
                    {!!msg.forwarded &&
                        <span className={styles.forwardedTxt}><i className="ri-corner-up-right-double-line"></i>Forwarded</span>}
                        {msg.replyOn &&
                            <OriginalMessage messages={messages} msg={messages.find((m: any) => m._id == msg.replyOn)} scrollToElement={scrollToElement} userId={user.id} orderChat={orderChat} />}
                    <MessageType messages={messages} msg={msg} userId={user.id} />
                    <span className={styles.msgBottom}>
                      {isMyMsg && <span className={styles.status}>{
                        (msg.seen.length && (msg.seen.length === orderChat.users.length - 1)) ?
                          <i className={`ri-check-double-line ${styles.seen}`}></i> :
                          <i className={`ri-check-double-line ${styles.unseen}`}></i>}</span>
                      }
                      {!!msg.edited && <span className={styles.edited}>Edited</span>}
                      <span className={styles.msgDate}>{drawMongodbTime(msg.createdAt, 'en')}</span>
                    </span>
                  </span>


                  {(msg.react && Object.keys(msg.react).length) ?
                    <span className={styles.bubbleEmoji}>
                      <ul className={styles.emojBbl}>
                        {Object.keys(msg.react).map((re) => <li key={re + msg._id}><span>{messageSender(re) ? messageSender(re)['first_name'] : ''}</span>{msg.react[re]}</li>)}
                      </ul>
                    </span>
                    :
                      <>
                      </>

                  }

                  {showEmoji &&
                    <div className={styles.bubbleEmojiSm}>
                      <i onClick={() => {
                        if (canIMakeActions) {
                          setShowEmoji(false)
                        }
                      }} className="ri-close-line"></i>
                      <EmojiPicker reactionsDefaultOpen={true} open={showEmoji} searchDisabled={true} onEmojiClick={emojiClick} autoFocusSearch={false} lazyLoadEmojis={true} />
                    </div>
                  }
                </div>
              </>
          }
        </IonItem>
      </li>
      <Modal open={showModal} onClose={closeModal} size={"calc( 100% - 30px )"}>
        <ul className={styles.toolsList}>
          <li>
            <div className={styles.bubbleEmojiSm}>
              {/*<i onClick={() => {*/}
              {/*  if (canIMakeActions) {*/}
              {/*    setShowEmoji(false)*/}
              {/*  }*/}
              {/*}} className="ri-close-line"></i>*/}
              <EmojiPicker reactionsDefaultOpen={true} open={true} searchDisabled={true} onEmojiClick={emojiClick} autoFocusSearch={false} lazyLoadEmojis={true} allowExpandReactions={false} />
            </div>
          </li>
          <li className={styles.replyMsg} onClick={() => {
            setForwardMsg(msg);
            setShowModal(false);
          }}><i className="ri-corner-up-right-double-line"></i>Forward
          </li>
          <li className={styles.replyMsg} onClick={() => {
            setReplyMsg(msg);
            setShowModal(false);
          }}><i className="ri-reply-line"></i>Reply</li>
          {user.id == msg.senderId &&
              <>
                {(messages[messages.length - 1]._id == msg._id && msg.messageType === 'text' && !msg.edited) &&
                    <li className={styles.replyMsg} onClick={() => {
                      setEditMsg(msg);
                      setShowModal(false);
                    }}><i className="ri-edit-line"></i>Edit
                    </li>
                }
                <li className={styles.deleteMsg} onClick={() => {
                  setDeleteMsgPop(msg);
                  setShowModal(false);
                }}><i className="ri-delete-bin-5-line"></i>Delete
                </li>
              </>
          }
        </ul>
      </Modal>
      </>
    );
  }

}

function OriginalMessage({ messages, msg, scrollToElement, userId, orderChat }:{messages:any,msg:any, scrollToElement:any, userId:any, orderChat:any}) {
  function scrollToMsgId(id:any) {
    const ele = document.getElementById(id);
    if (ele) {
      ele.classList.add('ryb-focus-bubble');
      setTimeout(() => {
        ele.classList.remove('ryb-focus-bubble');
      }, 4000);
      scrollToElement(ele);
    }
  }
  let messageTypeStyle = styles.msgText;
  if (msg.messageType === 'image') {
    messageTypeStyle = styles.msgImage;
  } else if (msg.messageType === 'document') {
    messageTypeStyle = styles.msgDocument;
  }

  function messageSender(senderId:any) {
    return orderChat['users']?.find((usr:any) => usr.id == senderId);
  }

  return (
    <>
      {msg &&
        <span className={`${styles.replyMsgContent} ${styles.noClick} ${messageTypeStyle}`} onClick={() => scrollToMsgId(msg._id)}>
          <span className={styles.replyName}>{messageSender(msg.senderId)['first_name']}</span>
          <MessageType messages={messages} msg={msg} userId={userId} />
        </span>
      }
    </>
  )
}