import React from 'react';
import {toggleAudio} from './utils/methods';
import styles from './CallScreen.module.css';
import { IonButton, IonButtons, IonIcon, IonToolbar } from '@ionic/react';
import { micOutline, micOffOutline, volumeHighOutline, volumeMuteOutline, callSharp, videocam, videocamOff } from 'ionicons/icons';
import { useAuth } from '../../contexts/AuthContext';

function AudioCallBtns({currentUserVideoRef, endCall}:{currentUserVideoRef:any, endCall:any}){
  return(

    <IonToolbar>
      <IonButtons slot="primary">
        <IonButton onClick={(e)=>{
            const btn = e.currentTarget;
            const icn:any = btn.querySelector('i');
            if(icn.classList.contains('ri-mic-off-line')){
              icn.classList.remove('ri-mic-off-line');
              icn.classList.add('ri-mic-line');
            }else{
              icn.classList.remove('ri-mic-line');
              icn.classList.add('ri-mic-off-line');
            }
            toggleAudio(currentUserVideoRef.current)
        }}>
              <IonIcon icon={micOutline} />
        </IonButton>
        <IonButton onClick={()=>endCall(true)} className={styles.endCall}>
          <IonIcon icon={callSharp}></IonIcon>
        </IonButton>
      </IonButtons>
    </IonToolbar>
  )
}

export default AudioCallBtns;