import React, {useRef, useState} from "react";
import UserImage from "../components/UserImage";
import OnlineStatusComponent from "../components/OnlineStatusComponent";
import CallButtons from "../components/communication/CallButtons";
import styles from "../components/communication/LiveChat.module.css";
import {CHATFILESURL, FILEFORMATPATH} from "../utils/common";
import {downloadFile} from "../utils/front";
import Modal from "../components/Modal";
import useTeamsStore from "../contexts/teams";
import ImagesModal from "../components/communication/imagesModal/ImagesModal";
import {IonItem} from "@ionic/react";

function UserInfo({user, visible, chat, socket, setMessages, messages}: { user: any, visible: boolean, chat:any, socket:any, setMessages:any, messages:any}) {
    const modalRef = useRef<any>(null);
    const [activeImg, setActiveImg] = useState(0);
    const [activeTab, setActiveTab] = useState("overview");
    const urlRegex = /https?:\/\/[^\s]+/g;
    const media = messages ? messages.filter((msg:any) => msg.messageType == 'image' && msg.deleted != 1) : [];
    const files = messages ? messages.filter((msg:any) => msg.messageType == 'document' && msg.deleted != 1) : [];
    const links = messages ? messages.filter((msg:any) => msg.message.match(urlRegex) && msg.deleted != 1) : [];
    const teams = useTeamsStore((state:any) => state.teams);
    const groups = teams.filter((team:any)=>team.users.find((usr:any)=>usr.id == user.id))

    const handleThumbnailClick = (index:number) => {
        setActiveImg(index);
    };

    const handleImgClick = (index:number) => {
        setActiveImg(index);
    };

    const handleNext = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === messages.length - 1 ? 0 : prevIndex + 1
        );
    };

    const handlePrev = () => {
        setActiveImg((prevIndex:any) =>
            prevIndex === 0 ? messages.length - 1 : prevIndex - 1
        );
    };

    return (
        <div className={`ryb-user-info${visible ? ' active' : ''}`}>

            <ul>
                <li className={`${activeTab === 'overview' ? ' active-tab-item' : ''}`} onClick={()=>setActiveTab('overview')}><i className="ri-information-2-line"></i>Overview</li>
                <li className={`${activeTab === 'media' ? ' active-tab-item' : ''}`} onClick={()=>setActiveTab('media')}><i className="ri-mv-ai-line" onClick={()=>setActiveTab('media')}></i>Media</li>
                <li className={`${activeTab === 'files' ? ' active-tab-item' : ''}`} onClick={()=>setActiveTab('files')}><i className="ri-file-copy-2-line" onClick={()=>setActiveTab('files')}></i>Files</li>
                <li className={`${activeTab === 'links' ? ' active-tab-item' : ''}`} onClick={()=>setActiveTab('links')}><i className="ri-links-line" onClick={()=>setActiveTab('links')}></i>Links</li>
                <li className={`${activeTab === 'teams' ? ' active-tab-item' : ''}`} onClick={()=>setActiveTab('teams')}><i className="ri-group-line" onClick={()=>setActiveTab('teams')}></i>Teams</li>
            </ul>
            <div>
                <div className={`ryb-tabs-content${activeTab === 'overview' ? ' active-tab' : ''}`}>
                    <div className="ryb-user-info-img">
                        <UserImage user={user} width={60} height={60} count={0} type="user" />
                        <span className="ryb-user-name">
                            <span>{user.fullName}</span>
                            <span className="ryb-user-position">
                                {user.job}
                            </span>
                        </span>
                    </div>
                    <ul className="ryb-social-links">
                        <li><a href="#" target="_blank"><i className="ri-facebook-fill"></i></a></li>
                        <li><a href="#" target="_blank"><i className="ri-linkedin-fill"></i></a></li>
                        <li><a href="#" target="_blank"><i className="ri-twitter-x-fill"></i></a></li>
                        <li><a href="#" target="_blank"><i className="ri-instagram-fill"></i></a></li>
                    </ul>
                    <div className="ryb-user-info-details">
                        <span>
                            <span>Online Status:</span>
                            <OnlineStatusComponent user={user}/>
                        </span>
                        <span>
                            <span><i className="ri-mail-line"></i>Email:</span>
                            {user.email}
                        </span>
                        {user.phone &&
                            <span>
                                <span><i className="ri-smartphone-line"></i>Phone Number:</span>
                                {user.phone}
                            </span>
                        }
                        { user.address &&
                            <span>
                                <span>Address:</span>
                                {user.address}
                            </span>
                        }
                        { user.about ?
                            <span>
                                <span>About:</span>
                                {user.about}
                            </span>
                            :
                            'Hi there Im' + user.fullName + ' and I am a ' + user.job + '!'
                        }
                    </div>
                    {chat && <div className="ryb-user-call-btns">
                        <CallButtons socket={socket} orderChat={chat} setMessages={setMessages}/>
                    </div>}
                </div>
                <div className={`ryb-tabs-content${activeTab === 'media' ? ' active-tab' : ''}`}>
                    <h5>Media</h5>
                    {
                        media.length ?
                            <div className="ryb-chat-media-grid">
                                { media.map((msg:any, index:any) => {
                                    return (
                                        <div key={msg._id + '-msg-media'}>
                                            <ImagesModal msg={msg} msgsArr={media} />
                                        </div>
                                    );
                                })
                                }
                            </div>
                            :
                            <div className="ryb-no-media-msgs">
                                <i className="ri-camera-off-line"></i>
                                Sorry no results found!
                            </div>
                    }
                </div>
                <div className={`ryb-tabs-content${activeTab === 'files' ? ' active-tab' : ''}`}>
                    <h5>Files</h5>
                    {
                        files.length ?
                        <div className="ryb-chat-files">
                            { files.map((msg:any) => {
                                const ext = msg.message.split('.').pop();
                                return (
                                    <div key={msg._id + 'doc'} onClick={() => downloadFile(msg.message)}>
                                        <span className="ryb-chat-files-img"><img alt="document" src={`${FILEFORMATPATH}${ext}.svg`} className={styles.msgImageEl} width={150} height={150} /></span>
                                        <span className="ryb-chat-files-name">
                                            {msg.message}
                                            <span>120 KB, TXT Document file</span>
                                        </span>
                                    </div>
                                );
                            })
                            }
                        </div>
                        :
                        <div className="ryb-no-media-msgs">
                            <i className="ri-file-forbid-line"></i>
                            Sorry no results found!
                        </div>
                    }
                </div>
                <div className={`ryb-tabs-content${activeTab === 'links' ? ' active-tab' : ''}`}>
                    <h5>Links</h5>
                    {
                        links.length ?
                            <div className="ryb-chat-files">
                                { links.map((msg:any, index:number) => {
                                    return (
                                        <div key={'lnk-' + index}>
                                            <span className="ryb-chat-files-img"><i className="ri-link"></i></span>
                                            <span className="ryb-chat-files-name">
                                                <a href={msg.message} target="_blank" className="ryb-chat-link">
                                                    {msg.message}
                                                </a>
                                            </span>
                                        </div>
                                    );
                                })
                                }
                            </div>
                            :
                            <div className="ryb-no-media-msgs">
                                <i className="ri-file-forbid-line"></i>
                                Sorry no results found!
                            </div>
                    }
                </div>
                <div className={`ryb-tabs-content${activeTab === 'teams' ? ' active-tab' : ''}`}>
                    <h5>Teams in common</h5>
                    { groups.length ?
                        <div className="ryb-chat-groups">
                            {groups.map((group:any, index:number)=>{
                                return(
                                    <div key={'lnk-' + index} onClick={()=> {}}>
                                        <IonItem href={`/dashboard/chat/${group.id}?type=team`}>
                                            <UserImage user={group} width={40} height={40} />
                                            {group.name}
                                        </IonItem>

                                    </div>
                                )
                            })}
                        </div>
                            :
                            <div className="ryb-no-media-msgs">
                                <i className="ri-group-line"></i>
                                Sorry no groups found!
                            </div>
                    }
                </div>
            </div>

        </div>
    );
}

export default UserInfo;