import React, {useEffect} from "react";
import useOnlinePeopleStore from "../contexts/onlineUsers";

function UserImage({user, type = "", width = 50, height = 50, count = 0}: { user: any, type?: string, width: number, height: number, count?: number}) {
    const onlinePeople = useOnlinePeopleStore((state:any) => state.onlinePeople);
    const isOnline = type === 'user' && onlinePeople[user?.id] && onlinePeople[user.id]['socketId'];

    return (
        <>
        {!!count && <span className="ryb-new-msg">{count}</span>}
        <span className="ryb-chat-side-user-img">
            {!!(user && user.image) ? 
                <img src={user.userImage ? user.userImage : user.teamImage} className="ryb-chat-head-user-img" width={width} height={height} alt={'user image'} /> 
                : 
                <span className="ryb-user-letters">{user?.name ? `${user && user.name[0]}${user && user.name[1]}` : `${user?.first_name && user.first_name[0]}${user?.last_name && user.last_name[0]}`}</span>
            }
            {type === 'user' && <span className={`ryb-status-${isOnline ? 'online' : 'offline'}`}></span>}
        </span>
        </>
    );
}

export default UserImage;