import React from 'react'
import styles from "./ToolTip.module.css";

function ToolTip({ children, text, dir = null, align = null }:{children:any, text:any, dir:any, align?:any}) {
    let dr, al;
    if (dir == 'bottom') {
        dr = styles.bottom;
    } else if (dir == 'right') {
        dr = styles.right;
    } else if (dir == 'left') {
        dr = styles.left;
    }
    if (align == 'right') {
        al = styles.rightAlign;
    }
    return (
        <span className={`${styles.tooltipWrap} ${dr} ${al}`}>
            <span className={styles.tooltipIcon}>
                {children}
            </span>
            <span className={styles.tooltipText}>{text}</span>
        </span>
    )
}

export default ToolTip