import React, { ReactNode } from 'react';
import { IonHeader, IonToolbar, IonButtons, IonTitle, IonContent, IonPage, IonButton, IonIcon, isPlatform } from '@ionic/react';
import { useHistory } from 'react-router-dom';
import { useEffect } from 'react';
import { arrowBackOutline } from 'ionicons/icons';
import { App } from '@capacitor/app';
// import { Keyboard } from '@capacitor/keyboard';

interface PreventBackProps {
  title: any;
  customClass?: string;
  children: React.ReactNode;
  headerElement?: ReactNode;
}

const PreventBack: React.FC<PreventBackProps> = ({ title, children, headerElement, customClass }) => {
  const history = useHistory();
  const platform = isPlatform('android') || isPlatform('ios');

  const handleBack = () => {
    history.goBack();
  };

  // useEffect(() => {
  //   if (isPlatform('android') || isPlatform('ios')) {
  //     const setupBackListener = async () => {
  //       const removeBackListener = await App.addListener('backButton', (event) => {
  //         if (event.canGoBack) {
  //           handleBack();
  //         } else {
  //           App.exitApp();
  //         }
  //       });
  //       return () => {
  //         removeBackListener.remove();
  //       };
  //     };
  //     const cleanupListener = setupBackListener();
  //     return () => {
  //       cleanupListener.then((cleanup) => cleanup());
  //     };
  //   }
  // }, [platform, history]);

  // useEffect(() => {
  //   // Configure keyboard behavior
  //   Keyboard.setAccessoryBarVisible({ isVisible: true });
  //   Keyboard.setScroll({ isDisabled: false });
  //   Keyboard.setResizeMode({ mode: 'native' });
    
  //   // Optional: add listeners for additional control
  //   Keyboard.addListener('keyboardWillShow', () => {
  //     // You can add custom behavior here
  //   });
    
  //   return () => {
  //     Keyboard.removeAllListeners();
  //   };
  // }, []);


  return (
    <IonPage className={customClass}>
      <IonHeader>
        <IonToolbar>
          <IonButtons slot="start" className='ryb-back-btns'>
            <IonButton onClick={handleBack} fill="clear">
              <IonIcon icon={arrowBackOutline} />
            </IonButton>
          </IonButtons>
          {headerElement && headerElement}
          <span className='ryb-inner-title'>{title}</span>
        </IonToolbar>
      </IonHeader>
      <IonContent scrollY={false} className='ryb-ion-content'>
        {children}
      </IonContent>
    </IonPage>
  );
};

export default PreventBack;