import {formatDateUK, getTime} from "../utils/common";
import React from "react";
import useOnlinePeopleStore from "../contexts/onlineUsers";
import {formatDate} from "../utils/front";

function OnlineStatusComponent({user} : {user:any}){
    function onlineUserData(user:any){
        const onlinePeople = useOnlinePeopleStore((state:any) => state.onlinePeople);
        const isOnline = user && onlinePeople[user.id] && onlinePeople[user.id]['socketId'];
        return (user && onlinePeople[user.id]) ? {onlineUser: onlinePeople[user.id], isOnline} : null;
    }

    let onlineUser = onlineUserData(user);
    function isToday(date:any) {
        return (new Date(date)).toDateString() === new Date().toDateString();
    }

    return(
        <>
            {onlineUser ? <>
                    {
                        onlineUser.isOnline ?
                            <span className="ryb-status-online-txt">
                                <i className="ri-circle-fill ryb-status-online"></i>
                                <span>Online Now</span>
                            </span>
                            : <>
                                {
                                    isToday(onlineUser['onlineUser']['lastSeen'])
                                    ? (`Last seen: ${getTime(onlineUser['onlineUser']['lastSeen'], '12', false)}`) :
                                        `Last seen: ${formatDate(formatDateUK(onlineUser['onlineUser']['lastSeen']))} at ${getTime(onlineUser['onlineUser']['lastSeen'], '12', false)}`

                                }
                            </>
                    }
                </>
                :
                'Offline'
            }
        </>
    )
}

export default OnlineStatusComponent;