import React from "react";
import { useEffect, useState } from "react";
import { createPortal } from "react-dom";
import styles from './Modal.module.css';

function Modal({ children, trigger = null, ref, className = '', head = '', showHead = true }:{ children:any, trigger?:any, ref:any, className?:any, head?:any, showHead?:any }) {
    const [openModal, setOpenModal] = useState(false);
    useEffect(() => {
        if (trigger) {
            const btnEl = document.getElementById(trigger);
            if (btnEl) {
                btnEl.addEventListener('click', function (e) {
                    e.preventDefault();
                    setOpenModal(true);
                });
            }
        }

        ref.current = {};
        if (ref.current) {
            ref.current.dismiss = function () {
                setOpenModal(false);
            }
            ref.current.open = function () {
                setOpenModal(true);
            }
        }

    }, []);

    return (
        <>
            {openModal && createPortal(
                <div className={"popup-container" + (className ? ' ' + className : '')}>
                    <i className="ri-arrow-left-line close-icon" onClick={() => setOpenModal(false)}></i>
                    {/*<div>*/}
                        {/*{showHead ? (*/}
                        {/*    <>*/}
                        {/*        <h5 className="ryb-pop-head">*/}
                        {/*            {head}*/}
                        {/*            /!*<i className="ri-close-line" onClick={() => setOpenModal(false)}></i>*!/*/}
                        {/*        </h5>*/}
                        {/*    </>*/}
                        {/*) : null}*/}
                        {children}
                    {/*</div>*/}
                </div>,
                document.body)
            }
        </>
    )
}

export default Modal;