import styles from "./mails.module.css";
import {formatDate, formatTime} from "../../utils/front";
import {useEffect, useState} from "react";
import MailToolbar from "../Email/MailToolbar";
import {addEmptyLines, getEmails, isMailAllowed} from "../Email/utils/methods";
import Loading from "../../components/Loading";

function MessageDetails({
        msgDetails,
        msgID,
        folderId,
        folders,
        setMsgDetails,
        allowAssets,
        setAllowAssets,
        methods,
        mode,
        arrowActive,
        setArrowActive,
        loading
    } : {
        msgDetails: any,
        msgID: any,
        folderId: any,
        folders: any,
        setMsgDetails: any,
        allowAssets: any,
        setAllowAssets: any,
        methods: any,
        mode: any,
        arrowActive: any,
        setArrowActive: any,
        loading: boolean
    }) {
    const [showDetails, setShowDetails] = useState(false);
    const [showHeaders, setShowHeaders] = useState(false);
    const [showSource, setShowSource] = useState(false);
    const [showPlain, setShowPlain] = useState(false);

    function Emails({emails}: { emails: [] | null }) {
        return (
            <span>
              {emails &&
                  emails.map((person: any, index: number) => (
                      <a key={"person-" + index}
                         href={`mailto::${person.mail}`}>{person.personal ? person.personal : person.mail}</a>
                  ))}
            </span>
        )
    }

    useEffect(() => {

        const allowedMails = localStorage.getItem('allowedMails');
        if (msgDetails) {
            let mails = getEmails(msgDetails.from);
            if (allowedMails) {
                let allowedMailsArr = JSON.parse(allowedMails);
                mails.map(((mail: string) => {
                    if (!allowedMailsArr.includes(mail)) {
                        allowedMailsArr.push(mail);
                    }
                }));
                localStorage.setItem('allowedMails', JSON.stringify(allowedMailsArr));
            } else {
                localStorage.setItem('allowedMails', JSON.stringify(mails));
            }
        }

    }, [allowAssets]);

    return (
        <div className={`${styles.emailDetails}${arrowActive ? ' ' + styles.activeMsg : ""}`}>
            {arrowActive && <div className={`ryb-back-btn ${styles.closeMsg}`}>
                Back<i className={`ri-arrow-right-line`} onClick={() => setArrowActive(false)}></i>
            </div>}
            {
                loading ?
                    <Loading/>
                    :
                    <>
                        <MailToolbar
                            msgID={msgID}
                            msgDetails={msgDetails}
                            folders={folders}
                            folderId={folderId}
                            methods={methods}
                            setMsgDetails={setMsgDetails}
                            setShowSource={setShowSource}

                        />
                        {msgDetails && msgID ? (
                            <>
                                <div className={styles.msgContentTitle}>
                                    <div>
                                        <p className={styles.msgMetaHead}>
                                            {msgDetails.subject}
                                        </p>
                                        <div className={`${styles.msgMeta}${ showDetails ? " " + styles.itemsStart : "" }`}>
                                            <img width={40} height={40} alt="" src="/contactpic.svg" />
                                            <div>
                                                <span className={styles.msgMetaList}>
                                                    <span>
                                                        <b>From</b>
                                                        <Emails emails={msgDetails.from}/>
                                                    </span>

                                                    {showDetails && (
                                                    <span className={styles.msgMetaTo}>
                                                      <b>To</b>
                                                      <Emails emails={msgDetails.to}/>
                                                    </span>
                                                  )}
                                                  {showDetails && msgDetails.cc && (
                                                      <span className={styles.msgMetaCC}>
                                                        <b>CC</b>
                                                        <Emails emails={msgDetails.cc}/>
                                                      </span>
                                                  )}

                                                  {showDetails && msgDetails.bcc && (
                                                      <span className={styles.msgMetaCC}>
                                                        <b>BCC</b>
                                                        <Emails emails={msgDetails.bcc}/>
                                                      </span>
                                                  )}
                                                  {showDetails && msgDetails.date && (
                                                      <span className={styles.msgMetaDate}>
                                                        <b>Date</b>
                                                        <span>
                                                          {formatDate(msgDetails.date)}{" "}
                                                            {formatTime(msgDetails.date)}
                                                        </span>
                                                      </span>
                                                  )}
                                                </span>

                                                <div className={styles.msgHeaderLinks}>
                                                    <span onClick={() => setShowDetails((prev) => !prev)}>
                                                      <i className="ri-mail-line"></i>Details
                                                    </span>
                                                    <span onClick={() => setShowHeaders(true)}>
                                                      <i className="ri-information-line"></i>Headers
                                                    </span>
                                                    <span onClick={() => setShowPlain((prev) => !prev)}>
                                                      <i className="ri-menu-line"></i>
                                                      <span>Plain text</span>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {showHeaders && (
                                    <div className={styles.showHeaders}>
                                        <i className="ri-close-line" onClick={() => setShowHeaders(false)}></i>
                                        <div>{msgDetails.headers && msgDetails.headers}</div>
                                    </div>
                                )}

                                {showSource && (
                                    <div className={styles.showHeaders}>
                                        <i className="ri-close-line" onClick={() => setShowSource(false)}></i>
                                        <div className={styles.showSource}>
                                            <pre>{msgDetails.row && msgDetails.row}</pre>
                                        </div>
                                    </div>
                                )}
                                {showPlain ? (
                                    msgDetails.text && (
                                        <pre className={styles.plainText}>{msgDetails.text}</pre>
                                    )
                                ) : (<>
                                    {!isMailAllowed(msgDetails) && folderId != 'Drafts' && (
                                        <div className={styles.warning}>
                                            <i className="ri-error-warning-fill"></i>
                                            To protect your privacy remote resources have been blocked.
                                            <button className="btn btn-sm no-wrap" onClick={() => msgDetails.id && setAllowAssets(msgDetails.id) }>Allow</button>
                                        </div>
                                    )}
                                    {folderId == 'Drafts' && msgDetails &&
                                        <div className={styles.information}>
                                            <i className="ri-error-warning-fill"></i>
                                            This is a draft message.
                                            <button className="btn btn-sm" onClick={() => { methods.updateDirAndMode('right', 'draft'); }}>
                                                Edit
                                            </button>
                                        </div>
                                    }
                                    {msgDetails.html && (
                                        <iframe id="msgFrame" srcDoc={msgDetails.html}></iframe>
                                    )}
                                    {!msgDetails.html && mode == "draft" &&
                                        <pre>
                                          {addEmptyLines(msgDetails.text)}
                                        </pre>
                                    }
                                    {msgDetails.attachments.length > 0 && (
                                        <ul className={styles.attachList}>
                                            {msgDetails.attachments.map((attachment: any, index:number) => (
                                                <li key={index}>
                                                    <a href={`data:application/octet-stream;base64,${attachment.content}`} download={attachment.name} title={attachment.name}>
                                                        <span className={styles.attchExt}>
                                                          <span>{attachment.extension}</span>
                                                          <img alt="" src="/ext.svg" width={36} height={46} />
                                                        </span>
                                                        <span className={styles.attachName}>
                                                            <b>{attachment.name}</b>
                                                            <i>({attachment.size})</i>
                                                        </span>
                                                    </a>
                                                </li>
                                            ))}
                                        </ul>
                                    )}
                                </>)}
                            </>
                        ) : (
                            <div className="ryb-msgs-intro">
                                <img width={400} height={328} alt="" src="/no-mails.png"/>
                                <div className="ryb-msgs-head">
                                    There are no messages selected!
                                </div>
                                Select one and start Emailing!
                            </div>
                        )}
                    </>
            }

        </div>
    )
}

export default MessageDetails;