import styles from "./mails.module.css";
import {getToken} from "../../utils/front";
import axios from "axios";

function MailToolbar({msgDetails, msgID, folderId, folders, methods, setMsgDetails, setShowSource} : {msgDetails:any, msgID:any, folderId:any, folders:any, methods:any, setMsgDetails:any, setShowSource:any}){
    const userToken = getToken();

    const postAction = async (action: string) => {
      axios.post(
        import.meta.env.VITE_BASE_URL + "mail/" + action + "/" + folderId + "/" + msgID,
        {}, {
          headers: {
            Authorization: "Bearer " + userToken,
          },
        }
      )
      .then((res:any) => {
        const data = res.data;
        if(data.status === 'success' && data.message){
          if(action === 'read' || action === 'unread'){
              methods.updateMessagesState(data.message);
              methods.updateFoldersCountState(data.message);
          }else if(action === 'spam' || action === 'archive' || action === 'trash' || action === 'delete'){
              methods.spliceMessage(data.message);
              methods.folderClick(data.folder);
              setMsgDetails(null);
          }else if(action === 'flagged' || action === 'unflagged'){
              methods.updateMessagesState(data.message);
          }
        }
        if (data.err == "exists") {
            methods.updateHint(data.text);
        }
      })
      .catch((err:any) => {
        console.log(err);
      });
    };

    const moveAction = async (action: string, to: string) => {
        axios
            .post(
                import.meta.env.VITE_BASE_URL + "mail/" + action + "/" + folderId + "/" + msgID + "/" + to,
                {
                    folderId,
                    msgID,
                    to,
                },
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res:any) => {
                const data = res.data;
                if(data.status === 'success' && data.message){
                    methods.spliceMessage(data.message);
                    setMsgDetails(null);
                } else if(data.status === 'copied'){
                    methods.updateHint(data.message);
                }
                if (data.err == "exists") {
                    methods.updateHint(data.text);
                }
            })
            .catch((err:any) => {
                console.log(err);
            });
    };

    function printMessage() {
        const iframe: any = document.getElementById("msgFrame");
        const iframeWindow = iframe.contentWindow;
        iframeWindow.focus();
        iframeWindow.print();
    }

    const getAction = (action: string) => {
        axios
            .get(
                import.meta.env.VITE_BASE_URL + "mail/" + action + "/" + folderId + "/" + msgID,
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res:any) => {
                if( action == 'export' ){
                    const blob = new Blob([res.data]);
                    const url = window.URL.createObjectURL(blob);
                    const a = document.createElement("a");
                    a.href = url;
                    a.download = `email-message-${msgID}.eml`;
                    document.body.appendChild(a);
                    a.click();
                    window.URL.revokeObjectURL(url);
                    document.body.removeChild(a);
                }
            })
            .catch((err:any) => {
                console.log(err);
            });
    };
    
    return(
      <>
      {msgDetails && msgID && (
        <ul className={styles.mailToolbar} id="toolbar-menu">
          <li title="Reply to sender" className={folderId == "Drafts" ? styles.disabled : ''}>
            <span className={styles.hasChildren}>
              <i className="ri-reply-line"></i>
              <span>Reply</span>
            </span>
              <div className={styles.dropDown}>
                  <span onClick={() => {methods.updateDirAndMode("right", "reply");}}>
                    <i className="ri-reply-line"></i>Reply
                  </span>
                  <span title="Reply to list or to sender and all recipients" onClick={() => {methods.updateDirAndMode("right", "reply all");}}>
                    <i className="ri-reply-all-line"></i>Reply All
                  </span>
              </div>
          </li>
          <li className={folderId == "Drafts" ? styles.disabled : ''}>
            <span
                className="forward"
                title="Forward the message"
                onClick={() => {
                    methods.updateDirAndMode("right", "forward");
                }}
            >
              <i className="ri-share-forward-line"></i>
              <span>Forward</span>
            </span>
          </li>
          <li>
            <span
                title="Move message to trash"
                onClick={() => postAction(msgDetails.folder == "Trash" ? "delete" : "trash")}
                >
              <i className="ri-delete-bin-5-line"></i>
              <span>{msgDetails.folder == "Trash" ? "Delete" : "Trash"}</span>
            </span>
          </li>
          <li>
            <span
                title="Archive this message"
                onClick={() => postAction("archive")}
                >
              <i className="ri-archive-line"></i>
              <span>Archive</span>
            </span>
          </li>
          <li>
            <span>
              <i className="ri-price-tag-3-fill"></i>
              <span>Mark</span>
            </span>
              <div className={styles.dropDown}>
                  <span onClick={() => postAction("read")}>
                    <i className="ri-mail-check-line"></i>Read
                  </span>
                          <span onClick={() => postAction("unread")}>
                    <i className="ri-mail-unread-line"></i>Unread
                  </span>
                          <span onClick={() => postAction("flagged")}>
                    <i className="ri-flag-2-fill"></i>Flagged
                  </span>
                          <span onClick={() => postAction("unflagged")}>
                    <i className="ri-flag-2-line"></i>Unflagged
                  </span>
              </div>
          </li>
          <li>
            <span
                title="Move to junk folder"
                onClick={() => postAction("spam")}
            >
              <i className="ri-fire-line"></i>
              <span>Spam</span>
            </span>
          </li>
          <li>
            <span>
              <i className="ri-more-2-fill"></i>
            </span>
            <div className={styles.dropDown}>
              <span onClick={printMessage}>
                <i className="ri-mail-check-line"></i>Print this message
              </span>
              <span className={styles.hasChildren + ' ' + styles.hasChildrenSub}>
                <i className="ri-folder-5-fill"></i>Move to
                <span className={styles.subMenu}>
                  {folders &&
                      Object.values(folders).map((folder:any, index) => {
                          const foldr = folder.name;
                          return (
                              <span key={"folder" + index} onClick={() => moveAction('move', foldr)}>
                          {foldr.toLowerCase()}
                        </span>
                          );
                      })
                  }
                </span>
              </span>
              <span className={styles.hasChildren + ' ' + styles.hasChildrenSub}>
                  <i className="ri-file-copy-fill"></i>Copy to
                  <span className={styles.subMenu}>
                    {folders &&
                        Object.values(folders).map((folder:any, index) => {
                            const foldr = folder.name;
                            return (
                                <span key={"folder" + index} onClick={() => moveAction('copy', foldr)}>
                            {foldr.toLowerCase()}
                          </span>
                            );
                        })
                    }
                  </span>
              </span>
              <span onClick={() => setShowSource(true)}>
                <i className="ri-code-box-fill"></i>View Source
              </span>
              <span onClick={() => getAction("export")}>
                <i className="ri-upload-2-line"></i>Export Message
              </span>
            </div>
          </li>
        </ul>
      )}
      </>
    )
}

export default MailToolbar;