"use client";
import { useEffect, useState } from "react";
import { getToken } from "../../utils/front";
import axios from "axios";
import styles from "./mails.module.css";
import FoldersManager from "../Email/FoldersManager";
import FoldersList from "../Email/FoldersList";
import ComposeForm from "../Email/ComposeForm";
import EmailsList from "../Email/EmailsList";
import FoldersTopBar from "../Email/FoldersTopBar";
import {isMailAllowed} from "../Email/utils/methods";

interface MsgDetails {
  subject?: string;
  from?: string;
  fromEmail?: string;
  to?: string;
  toEmail?: string;
  date?: string;
  headers?: string;
  text?: string;
  html?: string;
  id?: string;
  row?: string;
}

interface Pager {
  first_page_url?: string;
  prev_page_url?: string;
  next_page_url?: string;
  last_page_url?: string;
  from?: number;
  to?: number;
  total?: number;
}
const GetEmails = () => {
  const userToken = getToken();
  const [folders, setFolders] = useState<[]>([]);
  const [showFolders, setShowFolders] = useState(false);
  const [messages, setMessages] = useState<[]>([]);
  const [pager, setPager] = useState<Pager>({});
  const [folderId, setFolderId] = useState("INBOX");
  const [msgID, setMsgID] = useState(null);
  const [msgDetails, setMsgDetails] = useState<MsgDetails | null>(null);
  const [isOpened, setIsOpened] = useState(false);
  const [modalOpen, setModalOpen] = useState(false);
  const [direction, setDirection] = useState("left");
  const [mode, setMode] = useState("compose");
  const [hint, setHint] = useState("");
  const [page, setPage] = useState(import.meta.env.VITE_BASE_URL + "mails/" + folderId + "?imap_page=1");
  const [refreshing, setRefreshing] = useState(false);
  let i = 1;

  const getMessages = () => {
    axios
      .get(page, {
        headers: {
          Authorization: "Bearer " + userToken,
        },
      })
      .then((res:any) => {
        const data = res.data;
        if(data.status === 'success'){
          setMessages(data.messages.data);
          setPager(data.messages);
        }

      })
      .catch((err:any) => {
        console.log(err);
      }).finally(()=>setRefreshing(false));
  }

  useEffect(() => {
    if (i) {
      i = 0;
      axios
        .get(import.meta.env.VITE_BASE_URL + "mails", {
          headers: {
            Authorization: "Bearer " + userToken,
          },
        })
        .then((res:any) => {
          if(res.data.status === 'success'){
            setFolders(res.data.folders);
          }
        })
        .catch((err:any) => {
          console.log(err);
        });

      setInterval(()=>{
        setRefreshing(true);
      }, 30000);
    }
  }, []);

  useEffect(() => {
    if(refreshing){
      getMessages();
    }
  }, [refreshing]);

  useEffect(() => {
    getMessages();
  }, [folderId, page]);

  useEffect(() => {
    if (msgID) {
      const isAllowed = isMailAllowed(messages.find((msg:any)=>msg.id == msgID));
      axios
        .get(
          (import.meta.env.VITE_BASE_URL +
            "mails/" +
            folderId +
            "/" +
            msgID +
            "/" +
              (isAllowed ? msgID : 'no')),
          {
            headers: {
              Authorization: "Bearer " + userToken,
            },
          }
        )
        .then((res:any) => {
          const data = res.data;
          if(data.status === 'success'){
            setMsgDetails(data.mail);
          }

        })
        .catch((err:any) => {
          console.log(err);
        });
    }
  }, [folderId, msgID]);

  useEffect(()=>{
    if(msgDetails){
      updateMessagesState(msgDetails);
      updateFoldersCountState(msgDetails);
    }
  }, [msgDetails]);

  function updateMessagesState(message:any){
    setMessages((prev)=>{
      let arr:any = [];
      prev.map((msg:any)=>{
        if(msg.id == message.id && folderId === message.folder){
          arr.push(message);
        }else{
          arr.push(msg);
        }
      });
      return arr;
    });
  }

  function topbarActions(action:any, folder:any){
    if(action === 'mark-all-read'){
      setMessages((prev)=>{
        let arr:any = [];
        prev.map((msg:any)=>{
          msg.seen = 'yes';
          arr.push(msg);
        });
        return arr;
      });
      setFolders(prevFolder=>{
        let arr:any = [];
        prevFolder.map((fold:any)=>{
          if(fold.name == folder){
            arr.push({...fold, unseen_count: 0});
          }else{
            arr.push(fold);
          }
        })
        return arr;
      });
    }else if(action === 'empty'){
      setMessages([]);
      setFolders(prevFolder=>{
        let arr:any = [];
        prevFolder.map((fold:any)=>{
          if(fold.name == folder){
            arr.push({...fold, unseen_count: 0});
          }else{
            arr.push(fold);
          }
        })
        return arr;
      });
    }

  }

  function updateFoldersCountState(message:any){
    let msg:any = messages.find((msg:any)=>msg.id == message.id);
    if(msg && msg.seen !== message.seen){
      setFolders(prevFolder=>{
        let arr:any = [];
        prevFolder.map((fold:any)=>{
          if(fold.name == message.folder){
            const folderCount = msg.seen == 'no' &&  message.seen === 'yes' ? fold.unseen_count - 1 : fold.unseen_count + 1;
            arr.push({...fold, unseen_count: folderCount});
          }else{
            arr.push(fold);
          }
        })
        return arr;
      });
    }
  }

  function updateDirAndMode(dir:any, modeType:any){
    if(dir){
      setDirection(dir);
    }
    if(modeType){
      setMode(modeType);
    }
    setIsOpened(true);
  }

  function folderClick(folder: any) {
    setFolderId(prevFold=>{
      if(prevFold === folder){
        getMessages();
      }
      return folder;
    });
    setMsgID(null);
    setPage(
      import.meta.env.VITE_BASE_URL + "mails/" + folder + "?imap_page=1"
    );
    setShowFolders(false);
  }

  function updateHint(message:string){
    setHint(message);
    setTimeout(() => {
      setHint("");
    }, 4000);
  }

  return (
    <>
      {refreshing && <i className={`ri-refresh-line ${styles.refreshing}`}></i>}
      <span className={styles.compose} onClick={() => { updateDirAndMode('left', 'compose'); }}>
        <i className="ri-add-line"></i>
      </span>

      <div className={styles.container}>
        {hint && <div className={styles.hint}>{hint}</div>}
        <div className={styles.folders}>
          <div>
            <i className="ri-menu-line" onClick={()=>{setShowFolders(!showFolders)}}></i> <span className={styles.currentFolder}>Inbox</span>
            { showFolders && <FoldersList folders={folders} folderClick={folderClick} folderId={folderId} setShowFolders={setShowFolders} /> }
          </div>
          <FoldersTopBar
              updateDirAndMode={updateDirAndMode}
              folderId={folderId}
              updateHint={updateHint}
              setModalOpen={setModalOpen}
              topbarActions={topbarActions}
          />
        </div>

        <div className={styles.emails}>
          <EmailsList
              messages={messages}
              getMessages={getMessages}
              msgID={msgID}
              folderId={folderId}
              setMsgID={setMsgID}
              setMessages={setMessages}
              setPage={setPage}
              setPager={setPager}
              pager={pager}
              updateHint={updateHint}
          />
        </div>
      </div>
      {isOpened && (
        <ComposeForm
            direction={direction}
            msgDetails={msgDetails}
            mode={mode}
            setIsOpened={setIsOpened}
            folderClick={folderClick}
        />
      )}
      <FoldersManager modalOpen={modalOpen} setFolders={setFolders} setModalOpen={setModalOpen} folders={folders} updateHint={updateHint} />
    </>
  );
};

export default GetEmails;
