import styles from "./mails.module.css";
import {useState} from "react";
import axios from "axios";
import {getToken} from "../../utils/front";

function FoldersTopBar({folderId, setModalOpen, updateHint, updateDirAndMode, topbarActions}: {updateDirAndMode:any, folderId:any, setModalOpen:any, updateHint:any, topbarActions:any}){
    const userToken = getToken();
    const [activeMen, setActiveMen] = useState(false);
    const folderSettings = async (action: string) => {
        axios
            .post(
                import.meta.env.VITE_BASE_URL + "mail/" + action + "/" + folderId,
                {},
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res:any) => {
                const data = res.data;
                if(data.status === 'success' && data.message){
                    updateHint(data.message);
                    topbarActions(action, folderId);
                }

            })
            .catch((err:any) => {
                console.log(err);
            });
    };
    return (
        <div>
            <i className="ri-more-2-fill" onClick={() => setActiveMen((prev) => !prev)}></i>
            <ul className={activeMen ? styles.active : ""}>
                <li onClick={() => {
                    setActiveMen(false);
                    folderSettings('empty');
                }}>
                    <i className="ri-eraser-fill"></i>Empty
                </li>
                <li onClick={() => {
                    setActiveMen(false);
                    folderSettings('mark-all-read');
                }}>
                    <i className="ri-mail-open-line"></i>
                    Mark all as read
                </li>
                <li onClick={() => {
                    setActiveMen(false);
                    setModalOpen(true)
                }}>
                    <i className="ri-folder-4-fill"></i>Manage folders
                </li>
            </ul>
        </div>
    )
}

export default FoldersTopBar;