import {Modal} from "rsuite";
import styles from "./mails.module.css";
import Icon from "../Email/Icon";
import axios from "axios";
import {useState} from "react";
import {getToken} from "../../utils/front";

function FoldersManager({setModalOpen, modalOpen, folders, updateHint, setFolders}: {setModalOpen:any, modalOpen:any, folders:any, updateHint:any, setFolders:any}){
    const userToken = getToken();
    const [addFolder, setAddFolder] = useState("");
    const [editedFolder, setEditedFolder] = useState("");
    const [showEdit, setShowEdit] = useState("");
    const [isAdd, setIsAdd] = useState(false);
    const [folderId, setFolderId] = useState("INBOX");
    const defaultFolders = [
        'INBOX',
        'Sent',
        'Drafts',
        'Trash',
        'Junk',
        'spam',
        'Archive'
    ];

    const AddFolderAction = async () => {
        axios
            .post(
                import.meta.env.VITE_BASE_URL + "mail/add-folder",
                {addFolder},
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res) => {
                const data = res.data;
                if( data.status == 'success' ){
                    updateHint(data.text);
                    let arr = folders.slice(1);
                    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                    // @ts-expect-error
                    setFolders((prevState:[]) => [prevState[0], {name: data.folder, unseen_count: 0}, ...arr])
                    setModalOpen(false);
                }
            })
            .catch((err) => {
                console.log(err);
            });
    };

    const EditFolderAction = async () => {
        axios
            .post(
                import.meta.env.VITE_BASE_URL + "mail/edit-folder",
                {folderId, editedFolder},
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res) => {
                const data = res.data;
                if( data.status == 'success' ){
                    updateHint(data.text);
                    setFolders((prevFolders:[])=>{
                        let arr:[] = [];
                        prevFolders.map((oldFold:any)=>{
                            if(oldFold.name == folderId){
                                let fold:any = {...oldFold, name: editedFolder}
                                // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                // @ts-expect-error
                                arr.push(fold);
                            }else{
                                // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                // @ts-expect-error
                                arr.push(oldFold);
                            }
                        });
                        return arr;
                    });
                    setModalOpen(false);
                }
            })
            .catch((err) => {
                console.log(err);
            });
    };

    const deleteFolder = async (folder:any) => {
        axios
            .post(
                import.meta.env.VITE_BASE_URL + "mail/delete-folder",
                {folder},
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res) => {
                const data = res.data;
                if( data.status == 'success' ){
                    updateHint(data.text);
                    setFolders((prevFolders:[])=>{
                        let arr:[] = [];
                        prevFolders.map((oldFold:any)=>{
                            if(oldFold.name != data.folder){
                                // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                                // @ts-expect-error
                                arr.push(oldFold);
                            }
                        });
                        return arr;
                    });
                }
            })
            .catch((err) => {
                console.log(err);
            });
    };
    return(
        <Modal size="sm" open={modalOpen} onClose={()=>setModalOpen(false)}>
            <Modal.Header>
                <Modal.Title>Manage Folders</Modal.Title>
            </Modal.Header>
            <Modal.Body>
                <ul className={styles.modalFolders}>
                    {folders &&
                        Object.values(folders).map((folder:any, index:number) => {
                            const foldr:any = folder.name.toLowerCase();
                            return (
                                <li
                                    key={"folder" + index}
                                    onClick={() => setFolderId(folder.name)}
                                >
                                    <Icon name={foldr} />
                                    {foldr}
                                    {showEdit == folder.name &&
                                        <div className={styles.addFolderForm}>
                                            <input type="text" className="form-control" defaultValue={folder.name} onChange={(e) => setEditedFolder(e.target.value)} required />
                                            <button onClick={EditFolderAction}><i className="ri-check-double-line"></i></button>
                                            <button className={`ri-delete-bin-2-line ${styles.deleteFolder}`} onClick={()=> deleteFolder(folder.name)}></button>
                                            <button onClick={()=> setShowEdit("")}><i className="ri-close-line"></i></button>
                                        </div>
                                    }
                                    {!defaultFolders.includes(folder.name) &&
                                        <span className={`ri-file-edit-line ${styles.editFolder}`} onClick={()=> setShowEdit(folder.name)}></span>
                                    }
                                </li>
                            );
                        })}
                </ul>
                <div className={styles.addFolderWrap}>
                    <span className="btn btn-sm" onClick={()=> setIsAdd(prev => !prev)}><i className="ri-add-line"></i>Add Folder</span>
                    { isAdd &&
                        <div className={styles.addFolderForm}>
                            <input type="text" className="form-control" placeholder="Folder Name" onChange={(e) => setAddFolder(e.target.value)} required />
                            <button onClick={AddFolderAction}><i className="ri-check-double-line"></i></button>
                            <button onClick={()=> setIsAdd(false)}><i className="ri-close-line"></i></button>
                        </div>
                    }
                </div>
            </Modal.Body>
        </Modal>
    )
}

export default FoldersManager;