import styles from "./mails.module.css";
import Icon from "../Email/Icon";
import {useState} from "react";

function FoldersList({folders, folderClick, folderId, setShowFolders}:{folders:any, folderClick:any, folderId:any, setShowFolders:any}){
    return(
        <div className={styles.foldersList}>
            <h6 className={styles.foldersTitle}>Folders <i className="ri-close-line" onClick={()=>setShowFolders(false)}></i></h6>
            <ul className={styles.dropdown}>
                {folders &&
                    Object.values(folders).map((folder: any, index: number) => {
                        const seen = folder.unseen_count ? folder.unseen_count : 0,
                            foldr = folder.name.toLowerCase();
                        return (
                            <li key={"folder" + index} onClick={() => { folderClick(folder.name); }} className={folderId === folder.name ? styles.active : ""}>
                                <Icon name={foldr}/>
                                {foldr}
                                {seen > 0 && (
                                    <span className={styles.unseenCount}>{seen}</span>
                                )}
                            </li>
                        );
                    })}
            </ul>
        </div>
    )
}

export default FoldersList;