import styles from "./mails.module.css";
import {formatDate, getToken} from "../../utils/front";
import axios from "axios";
import {useEffect, useRef, useState} from "react";
import {getEmails} from "../Email/utils/methods";
import { IonItem } from "@ionic/react";
import { Link } from "react-router-dom";
import Loading from "../Loading";

function EmailsList({messages, getMessages, msgID, folderId, setMsgID, setMessages, setPage, setPager, pager, updateHint} : {messages:any, getMessages:any, msgID:any, folderId:any, setMsgID:any, setMessages:any, setPage:any, setPager:any, pager:any, updateHint:any}){
    const userToken = getToken();
    const [query, setQuery] = useState("");
    const [unreadClick, setUnreadClick] = useState(false);
    const [loading, setLoading] = useState(false);

    const searchMsgs = (queryVal:any, type:any) => {
        setLoading(true);
        axios
        .get(import.meta.env.VITE_BASE_URL + "mails-search/" + folderId + "/" + type + (queryVal && '/' + queryVal), {
            headers: {
                Authorization: "Bearer " + userToken,
            },
        })
        .then((res:any) => {
            const data = res.data;
            if(data.status === 'success'){
                if(data.messages && data.messages.data.length){
                    setMessages(data.messages.data);
                    setPager(data.messages);
                }else{
                    updateHint('no results found');
                }
                setLoading(false);
            }
        })
        .catch((err:any) => {
            console.log(err);
        }).finally(()=>{
            setLoading(false);
        });
    };

    const handleKeyPress = (e:any) => {
        if (e.key === 'Enter') {
            searchMsgs(query, 'search');
            setUnreadClick(false);
        }
    };

    const unreadAction = ()=>{
        if(!unreadClick){
            searchMsgs("UNSEEN", 'unread');
        }else {
            searchMsgs("", 'search')
        }
        setUnreadClick((prev)=>!prev);
    }

    return(
        <>
        { loading ?
            <Loading />
            :
            <div className={styles.emailsList}>
                {messages.length ? (
                    <>
                        <div className={styles.msgsTopBar}>
                            <span><i className="ri-drag-drop-fill"></i>Select</span>
                            <span onClick={getMessages}><i className="ri-refresh-line"></i>Refresh</span>
                            <span className={`${unreadClick ? styles.unreadMsgs : ''}`} onClick={unreadAction}><i className="ri-mail-unread-fill"></i>Unread</span>
                        </div>
                        <div className={styles.searchMessages}>
                            <div className={styles.searchMessagesInput}>
                                <i className="ri-search-2-line"></i>
                                <input type="search" onKeyDown={handleKeyPress} onChange={(e) => setQuery(e.target.value)} />
                            </div>
                            <div className={styles.srchFilter}>
                                <i className="ri-equalizer-line"></i>
                            </div>
                        </div>
                        <ul>
                            {messages
                                .map((message: any, index:number) => {
                                    return (
                                        <li
                                            key={"msgs-" + index}
                                            className={`${
                                                message.seen == "yes" ? styles.seen : ""
                                            }${
                                                message.important ?  ' ' + styles.important : ""
                                            }${
                                                (msgID && msgID == message.id)
                                                    ? " " + styles.active
                                                    : ""
                                            }`}

                                        >
                                            <Link to={"/dashboard/mail/" + folderId + "/" + message.id}>
                                                <span className={styles.msgListTitle}>
                                                <h6>{getEmails(folderId === 'Sent' ? message.to : message.from, ('personal'))}</h6>
                                                <span className={styles.msgListDate}>
                                                    {message.date && formatDate(message.date)}
                                                </span>
                                                </span>
                                                <span className={styles.msgListSubject}>
                                                    {message.subject}
                                                </span>
                                                {message.has_attachments && (
                                                    <i className={`ri-attachment-2 ${styles.listAttachIcon}`}></i>
                                                )}
                                            </Link>
                                        </li>
                                    );
                                })
                                .reverse()}
                        </ul>
                        <div className={styles.msgsPager}>
                            <i
                                className={`ri-arrow-left-double-line`}
                                title="First page"
                                onClick={() =>
                                    pager.first_page_url && setPage(pager.first_page_url)
                                }
                            ></i>
                            <i
                                className={`ri-arrow-left-s-line${
                                    !pager.prev_page_url ? " " + styles.disabled : ""
                                }`}
                                title="Previous page"
                                onClick={() =>
                                    pager.prev_page_url && setPage(pager.prev_page_url)
                                }
                            ></i>
                            <span>
                        Messages {pager.from} to {pager.to} of {pager.total}
                        </span>
                            <i
                                className={`ri-arrow-right-s-line${
                                    !pager.next_page_url ? " " + styles.disabled : ""
                                }`}
                                title="Next page"
                                onClick={() =>
                                    pager.next_page_url && setPage(pager.next_page_url)
                                }
                            ></i>
                            <i
                                className={`ri-arrow-right-double-line`}
                                title="Last page"
                                onClick={() =>
                                    pager.last_page_url && setPage(pager.last_page_url)
                                }
                            ></i>
                        </div>
                    </>
                ) : (
                    <div className={styles.noMessagesInList}>
                        <i className="ri-chat-off-fill"></i>
                        No Messages found
                    </div>
                )}
            </div>
        }
        </>
    )
}

export default EmailsList;