import {Button, Drawer, TagInput, Uploader} from "rsuite";
import styles from "./mails.module.css";
import {getToken, getUserData} from "../../utils/front";
import axios from "axios";
import {getEmails} from "../Email/utils/methods";
import {useEffect, useState, useCallback} from "react";
import QuillEditor from '../QuillEditor';
// import dynamic from 'next/dynamic';

// const Uploader = dynamic(() => import('rsuite').then((mod) => mod.Uploader), {
//     ssr: false,
// });
function ComposeForm({setIsOpened, direction, mode, msgDetails, folderClick}: {setIsOpened:any, direction:any, mode:any, msgDetails:any, folderClick:any}){
    const userToken = getToken();
    const [mailTo, setMailTo] = useState([]);
    const [mailCC, setMailCC] = useState((mode == "reply all" && msgDetails && msgDetails.cc) ? getEmails(msgDetails.cc) : []);
    const [mailBCC, setMailBCC] = useState([]);
    const [showMenu, setShowMenu] = useState(false);
    const [showItem, setShowItem] = useState<any>((mode == "reply all" && msgDetails && msgDetails.cc) ? ['cc'] : []);
    const [subject, setSubject] = useState('');
    const [message, setMessage] = useState('');
    const [fileList, setFileList] = useState<any>([]);
    const items = ['cc', 'bcc'];
    const [filesObj, setFilesObj] = useState([]);
    const handleContentChange = useCallback((content:any) => {
        setMessage(content);
    }, []);

    useEffect(()=>{
        if(msgDetails && mode != 'compose'){
            if( mode == 'reply' || mode == 'reply all' ){
                setSubject('RE: ' + msgDetails.subject);
            } else if(mode == 'forward'){
                setSubject('Fwd: ' + msgDetails.subject);
            }else if(mode === 'draft'){
                setSubject(msgDetails.subject);
            }
        }
        if (mode == "reply" || mode == "reply all" ){
            setMailTo(getEmails(mode == 'reply all' ? [...msgDetails.from, ...msgDetails.to] : msgDetails.from));
        }else if( mode === 'draft'){
            setMailTo(getEmails(msgDetails.to));
        }

    },[mode]);
    
    const composeAction = async () => {
        let obj:any = {
            from: getUserData().email,
            to: mailTo,
            subject: subject,
            message: message,
        }

        if(mailCC && mailCC.length){
            obj['mail_cc'] = mailCC;
        }

        if(mailBCC && mailBCC.length){
            obj['mail_bcc'] = mailBCC;
        }
        if( fileList.length ){
            obj['attachments'] = fileList;
            obj['filesObj'] = filesObj;
        }

        if( mode == 'draft' && msgDetails ){
            obj['draft_message_id'] = msgDetails.id;
        }

        axios.post(
            import.meta.env.VITE_BASE_URL + "mail/compose",
            obj,
            {
                headers: {
                    Authorization: "Bearer " + userToken,
                },
            }
        )
        .then((res) => {
            if(res.data.status === 'success'){
                setIsOpened(false);
                folderClick(res.data.folder);
            }
        })
        .catch((err) => {
            console.log(err);
        });
    };

    const saveDraft = async () => {
        const obj:any = {
            from: getUserData().email,
            to: mailTo,
            subject,
            message,
        }

        if(mailCC && mailCC.length){
            obj['mail_cc'] = mailCC;
        }

        if(mailBCC && mailBCC.length){
            obj['mail_bcc'] = mailBCC;
        }

        if( fileList.length ){
            obj['filesObj'] = filesObj;
        }

        axios.post(
            import.meta.env.VITE_BASE_URL + "mail/save-draft",
            obj,
            {
                headers: {
                    Authorization: "Bearer " + userToken,
                },
            }
        )
        .then((res) => {
            if(res.data.status === 'success'){
                setIsOpened(false);
                folderClick('Drafts');
            }
        })
        .catch((err) => {
            console.log(err);
        });

    }

    function removeItem(item:string){
        setShowItem((prev:[])=>prev.filter((val:string)=> val !== item));
    }

    function onSuccessEvent(response:any, file:any){
        if(response.status === 'success'){
            setFilesObj((prev:any)=>[...prev, {fileKey: file.fileKey, name: response.file_name, originalName: file.name}]);
            setFileList((prev:any)=>[...prev, response.file_name]);
        }
    }

    function onRemoveEvent(file:any){
        let fl:any = filesObj.find((fl:any)=>fl.fileKey == file.fileKey);
        let removedFile = fileList.find((fil:string)=> fl && fl.name == fil);
        if(removedFile){
            axios.post(
                import.meta.env.VITE_BASE_URL + "mail/remove-attachment",
                {file: removedFile},
                {
                    headers: {
                        Authorization: "Bearer " + userToken,
                    },
                }
            )
            .then((res) => {
                if(res.data.status === 'success'){
                    setFileList((prevFiles:any)=>{
                        let arr:any = [];
                        prevFiles.map((fil:string)=>{
                            if(removedFile){
                                arr.push(fil);
                            }
                        })
                        return arr;
                    });
                }
            })
            .catch((err) => {
                console.log(err);
            });
        }
    }

    return(
        <>
        <Drawer placement={direction} size="md" open={true} onClose={()=> setIsOpened(false)}>
            <Drawer.Header closeButton={false} className={styles.popHead}>
                <Drawer.Title>{mode}</Drawer.Title>
                <Button onClick={()=> setIsOpened(false)} className={styles.closePop}>
                    <i className="ri-close-line"></i>
                </Button>
            </Drawer.Header>
            <Drawer.Body className={`${styles.popContent}${ mode == "reply" ? " " + styles.replyMode : "" }`}>
                <form action={composeAction}>
                    <div className="ryb-pop-tabs-tab">
                        <div className="pop-form-group">
                            <label>From</label>
                            <span className="form-control">
                                {getUserData().email}
                            </span>
                        </div>

                        <div className={`pop-form-group ${styles.addCCForm}`}>
                            <label>To</label>
                            <TagInput name="to" trigger={'Comma'} {...({value: mailTo})} style={{width: "100%"}} onChange={(e: any) => setMailTo(e)}/>
                            <i className={`${styles.addCCBtn} ri-add-line`} onClick={()=>setShowMenu(prev=>!prev)}></i>
                            {showMenu &&
                            <ul>
                                {items.map((item:string)=>{
                                    return (
                                        <li key={item} onClick={() => {
                                            if(!showItem?.includes(item)) {
                                                setShowItem((prev:any)=> [...prev, item]);
                                            }
                                            setShowMenu(false);
                                        }}>{item}</li>
                                    )
                                })}
                            </ul>}
                        </div>

                        { showItem?.includes('cc') && <div className={`pop-form-group ${styles.addCCForm}`}>
                            <label>CC</label>
                            <TagInput name="mail_cc" trigger={'Comma'} {...({defaultValue: mailCC})} style={{width: "100%"}} onChange={(e: any) => setMailCC(e)}/>
                            <i className={`${styles.closeCCBtn} ri-close-line`} onClick={()=>{ removeItem('cc'); setMailCC([]); }}></i>
                        </div>}

                        {showItem?.includes('bcc') && <div className={`pop-form-group ${styles.addCCForm}`}>
                            <label>Bcc</label>
                            <TagInput name="mail_bcc" trigger={'Comma'} style={{width: "100%"}} onChange={(e: any) => setMailBCC(e)} />
                            <i className={`${styles.closeCCBtn} ri-close-line`} onClick={() => { removeItem('bcc'); setMailBCC([]); }}></i>
                        </div>}

                        <div className="pop-form-group">
                            <label>Subject</label>
                            <input
                                type="text"
                                name="subject"
                                className="form-control"
                                defaultValue={subject}
                                onInput={e=> setSubject((e.target as HTMLInputElement).value)}
                                required
                            />
                        </div>

                        { (mode == 'reply' || mode == 'reply all' || mode == 'forward') &&
                            <div className="pop-form-group">
                                <label>Original Message:</label>
                                <div dangerouslySetInnerHTML={{ __html: msgDetails.html }} />
                            </div>
                        }

                        <div className="pop-form-group">
                            <label>{ mode == 'reply' || mode == 'reply all' ? 'Reply' : 'Message' }</label>
                            <div className={styles.msgWrap}>
                                <QuillEditor initialContent={mode == 'draft' ? msgDetails.html : ''} onContentChange={handleContentChange} />
                            </div>
                        </div>

                        <div className="pop-form-group">
                            <Uploader action={import.meta.env.VITE_BASE_URL + "mail/upload-attachment"} onSuccess={onSuccessEvent} method={'post'} headers={{
                                Authorization: "Bearer " + userToken,
                            }} onRemove={onRemoveEvent} draggable>
                                <div style={{ height: 120, display: 'flex', alignItems: 'center', justifyContent: 'center', flexDirection: 'column', fontSize: "12px", color: "var(--color-neutral-6)" }}>
                                    <i className="ri-attachment-2" style={{ fontSize: '2.5rem', opacity: '.2' }}></i>
                                    <span>Click or Drag files for attachements!</span>
                                    <span>Maximum allowed file size is 75 MB</span>
                                </div>
                            </Uploader>
                        </div>

                        <div className="ryb-pop-footer">
                            <div>
                                <button type="submit" className="btn">Send<i className="ri-send-plane-line"></i></button>
                                {mode !== 'draft' &&
                                    <button type="button" className="btn btn-classic" onClick={saveDraft}>
                                        Save as Draft<i className="ri-save-line"></i>
                                    </button>
                                }
                            </div>
                        </div>
                    </div>
                </form>
            </Drawer.Body>
        </Drawer>
        </>
    )
}

export default ComposeForm;