"use client";
import { useState, useRef, useEffect } from 'react';
import styles from "./Copilot.module.css";
import {useQwenStream} from './useStreaming';

export default function QwenChat() {
    const [input, setInput] = useState<any>('');
    const messagesEndRef = useRef<any>(null);
    const messageInput = useRef<any>(null);
    const [displayText, setDisplayText] = useState('');
    const {
        generatedText,
        isLoading,
        error,
        conversation,
        setConversation,
        setGeneratedText,
        streamQwenResponse,
        stopGeneration,
        reset,
    } = useQwenStream();
    const textEndRef = useRef<HTMLDivElement>(null);
    const formatAIText = (text: string) => {
        let formatted = text.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-expect-error
        formatted = formatted.replace(/```(.*?)```/gs, '<code>$1</code>');
        formatted = formatted.replace(/###/g, '<hr />');
        return formatted;
    };

    useEffect(() => {
        if(generatedText == displayText && displayText != ''){
            setConversation(prev => [
                ...prev,
                { role: 'assistant', content: generatedText }
            ]);
            setGeneratedText('');
        }
        if(generatedText.length == 0 && displayText != ''){
            setDisplayText('');
        }
        if (generatedText.length > 0 && generatedText !== displayText) {
            const timer = setTimeout(() => {
                setDisplayText(generatedText.substring(0, displayText.length + 1));
            }, 10);
            return () => {
                clearTimeout(timer);
            };
        }
    }, [generatedText, displayText]);

    // Auto-scroll
    useEffect(() => {
        textEndRef.current?.scrollIntoView({ behavior: 'smooth', block: 'end' });
    }, [conversation, displayText]);

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        if (!input.trim()) return;
        streamQwenResponse(input);
        setInput('');
    };

    function textareaKeyPress(event:any) {
        if (event.keyCode == 13 && event.shiftKey == false) {
            handleSubmit(event);
        }
    }

    return (
        <div className={styles.wrapper}>
            <div className={styles.responseContainer}>
                {conversation.length ?
                    <div className={styles.message + ' ' + styles.aiMessage}>
                        {conversation.map((msg:any, index:number) => (
                            <div key={index} className={msg.role == 'user' ? styles.user : ''}>
                                {msg.role !== 'user' && <span className={styles.msgIcon}><i className="ri-dvd-ai-fill"></i></span>}
                                <pre dangerouslySetInnerHTML={{ __html: formatAIText(msg.content) }}></pre>
                            </div>
                        ))}

                        {(isLoading || generatedText) && <div className={`assistant`}>
                            <span className={styles.msgIcon}><i className="ri-dvd-ai-fill"></i></span>
                            <pre dangerouslySetInnerHTML={{__html: formatAIText(displayText)}}></pre>
                            {isLoading && <span className={styles.loadingMsg}></span>}
                        </div>}

                        <div className={styles.scrlDiv} ref={textEndRef} />
                        {!isLoading && !generatedText && <button type="button" onClick={reset} className={`btn ${styles.newChat}`}>
                            <i className="ri-chat-new-line"></i> New Chat
                        </button>}
                    </div>
                    :
                    <div className={styles.welcome}>
                        <h5><i className="ri-dvd-ai-fill"></i>Hi, I'm RAYSHub <span className="color-primary">Copilot.</span></h5>
                        <p>How can I help you today?</p>
                    </div>
                }
                <div ref={messagesEndRef} />
            </div>
            {error && <div className="error">{error}</div>}
            <form onSubmit={handleSubmit} className={styles.formWrap + ' ' + styles.chatInput}>
                <textarea
                    rows={3}
                    value={input}
                    onChange={(e) => setInput(e.target.value)}
                    placeholder="Ask Copilot something..."
                    disabled={isLoading}
                    ref={messageInput}
                    onKeyDown={(event)=> textareaKeyPress(event)}
                />
                {isLoading || generatedText ?
                    <button onClick={stopGeneration} className={styles.btn}>
                        <i className="ri-square-fill"></i>
                    </button>
                    :
                    <button type="submit" className={styles.btn} disabled={isLoading}>
                        <i className="ri-arrow-up-line"></i>
                    </button>
                }
            </form>
        </div>
    );
}
