
import { IonBackButton, IonButtons, IonContent, IonHeader, IonItem, IonPage, IonRefresher, IonRefresherContent, IonTitle, IonToolbar, useIonRouter } from '@ionic/react';
import { chevronBackOutline } from 'ionicons/icons';
import { ReactNode } from 'react';

interface AppLayoutProps {
  children: ReactNode;
  title?: ReactNode;
  headerElement?: ReactNode;
  refresh?: boolean,
  refresher?: any,
  handleRefresh?: () => void
}

const AppLayout = ({ children, title, headerElement, refresh, refresher, handleRefresh }: AppLayoutProps) => {

  const { canGoBack } = useIonRouter();

  return (
    <IonPage>
      <IonHeader>
        <IonToolbar>
          {!canGoBack && null}
          {canGoBack && <IonButtons slot="start">
            <IonBackButton text="" className="ryb-back-btn" icon={chevronBackOutline} ></IonBackButton>
          </IonButtons>}
          <IonTitle slot='start'>{title}</IonTitle>
          <IonItem slot='end'>{headerElement && headerElement}</IonItem>
        </IonToolbar>
      </IonHeader>
      <IonContent scrollY={false} className='ryb-ion-content'>
        {refresh && <IonRefresher slot="fixed" ref={refresher} onIonRefresh={handleRefresh()}>
          <IonRefresherContent
            pullingIcon="chevron-down-outline"
            refreshingSpinner="crescent"
            refreshingText="Refreshing..."
          />
        </IonRefresher>}
        {children}
      </IonContent>
    </IonPage>
  );
};

export default AppLayout;
