import React, { useEffect } from "react";
import Login from "./pages/Login";
import {Switch} from "react-router";
import { Route } from 'react-router-dom';
import { IonApp, setupIonicReact} from '@ionic/react';
import {AuthProvider} from "./contexts/AuthContext";
import { IonReactRouter } from '@ionic/react-router';
import Index from "./pages/Index";
import DashboardLayout from "./pages/DashboardLayout";
import CallScreen from "./components/communication/CallScreen";
import "rsuite/dist/rsuite-no-reset.min.css";
import 'remixicon/fonts/remixicon.css';
import './theme/style.css';
import { SplashScreen } from "@capacitor/splash-screen";
import { getUserData } from "./utils/front";
import { usePushNotifications } from "./utils/usePushNotifications";

setupIonicReact();

const App: React.FC = () => {
  
  if (getUserData()) {
    usePushNotifications();
  }
  useEffect(() => {
    const hideSplash = async () => {
      await SplashScreen.hide();
    };
    hideSplash();
  }, []);

  return (
    <IonApp>
      <IonReactRouter>
        <AuthProvider>
          <Switch>
            <Route exact path="/" component={Index} />
            <Route path="/login" component={Login} />
            <Route path="/dashboard" component={DashboardLayout} />
          </Switch>
        </AuthProvider>
      </IonReactRouter>
    </IonApp>
  );
};

export default App;
