import { CapacitorConfig } from '@capacitor/cli';

const config: CapacitorConfig = {
  appId: 'com.rayshub.app',
  appName: 'RAYSHub',
  webDir: 'dist',
  // server: {
  //   url: 'http://192.168.1.4:8100',
  //   cleartext: true
  // },
  "plugins": {
    "Keyboard": {
      "resize": true,
      "style": "dark",
      "resizeOnFullScreen": true
    },
    CapacitorCookies: {
      enabled: true
    },
    WebView: {
      allowPermissions: true,
      allowJavaScriptInAllowedDomains: true,
      mediaPlaybackRequiresUserGesture: false
    }
  },
  android: {
    webContentsDebuggingEnabled: true
  }

};

export default config;
