<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jdr_f_3t_invoices', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('invoiceable_id');
            $table->string('invoiceable_type');
            $table->timestamp('order_end_time')->nullable();
            $table->bigInteger('seeker_id');
            $table->bigInteger('provider_id');
            $table->boolean('has_tax_bill');
            $table->integer('tax_ratio');
            $table->integer('amount_before_tax');
            $table->integer('amount_tax');
            $table->integer('amount');
            $table->decimal('platform_ratio');
            $table->integer('platform_amount_before_tax');
            $table->integer('platform_amount_tax');
            $table->integer('platform_amount');
            $table->integer('gateway_fee_before_tax');
            $table->integer('gateway_fee_tax');
            $table->integer('gateway_fee');
            $table->string('payment_card_type');
            $table->string('payment_type')->default('card_payment');
            $table->bigInteger('file_id')->nullable();
            $table->boolean('file_status')->nullable();
            $table->enum('request_status', [""]);
            $table->timestamp('created_at');
            $table->timestamp('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jdr_f_3t_invoices');
    }
};
